% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tung_Huang_Nyugen_Khan_2014.R
\name{TungUbRF}
\alias{TungUbRF}
\title{Implements RF prediction interval method in Tung, Huang, Nyugen, Khan 2014.}
\usage{
TungUbRF(
  formula = NULL,
  train_data = NULL,
  pred_data = NULL,
  num_trees = NULL,
  min_node_size = NULL,
  m_try = NULL,
  keep_inbag = TRUE,
  intervals = TRUE,
  feature_num_trees = NULL,
  alpha = NULL,
  forest_type = "QRF",
  featureBias = TRUE,
  predictionBias = TRUE,
  R = NULL,
  num_threads = NULL,
  interval_type = NULL
)
}
\arguments{
\item{formula}{Object of class formula or character describing the model to fit. Interaction terms supported only for numerical variables.}

\item{train_data}{Training data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Matches ranger() requirements.}

\item{pred_data}{Test data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Utilizes ranger::predict() to get prediction intervals for test data.}

\item{num_trees}{Number of trees.}

\item{min_node_size}{Minimum number of observations before split at a node.}

\item{m_try}{Number of variables to randomly select from at each split.}

\item{keep_inbag}{Saves matrix of observations and which tree(s) they occur in. Required to be true to generate variance estimates for Ghosal, Hooker 2018 method. *Should not be an option...}

\item{intervals}{Generate prediction intervals or not.}

\item{alpha}{Significance level for prediction intervals.}

\item{featureBias}{perform feature bias step.}

\item{predictionBias}{perform prediction bias.}

\item{R}{number of RFs generated in feature bias stage of Tung 2014 prediction interval. Defualt is 10.}

\item{num_threads}{The number of threads to use in parallel. Default is the current number of cores.}

\item{interval_type}{Type of prediction interval to generate.
Options are \code{method = c("two-sided", "lower", "upper")}. Default is  \code{method = "two-sided"}.}

\item{feature_num_tree}{number of trees to be used in ech random forest generated for feature bias step.}
}
\description{
This function implements the feature bias and prediction bias methods outlined in Tung 2014.
}
\keyword{internal}
