% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.piar_index.R
\name{mean.piar_index}
\alias{mean.piar_index}
\title{Aggregate a price index over subperiods}
\usage{
\method{mean}{piar_index}(x, weights = NULL, window = 3L, na.rm = FALSE, r = 1, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{weights}{A numeric vector of weights for the index values in \code{x}. The
default is equal weights. It is usually easiest to specify these weights as
a matrix with a row for each index value in \code{x} and a column for each
time period.}

\item{window}{A positive integer giving the size of the window used to
average index values across subperiods. The default (3) turns a monthly
index into into a quarterly one. Non-integers are truncated towards 0.}

\item{na.rm}{Should missing values be removed? By default, missing values
are not removed. Setting \code{na.rm = TRUE} is equivalent to overall mean
imputation.}

\item{r}{Order of the generalized mean to aggregate index values. 0 for a
geometric index (the default for making elemental indexes), 1 for an
arithmetic index (the default for aggregating elemental indexes and
averaging indexes over subperiods), or -1 for a harmonic index (usually for
a Paasche index). Other values are possible; see
\code{\link[gpindex:generalized_mean]{gpindex::generalized_mean()}} for details.}

\item{...}{Further arguments passed to or used by methods.}
}
\value{
A price index with the same class as \code{x}.
}
\description{
Aggregate an index over subperiods by taking the (usually arithmetic) mean
of index values over consecutive windows of subperiods.
}
\details{
The \code{mean()} method constructs a set of non-overlapping windows of
length \code{window}, starting in the first period of the index, and takes
the mean of each index value in these windows for each level of the index.
The last window is discarded if it is incomplete, so that index values are
always averaged over \code{window} periods. The names for the first time
period in each window form the new names for the aggregated time periods.
Note that percent-change contributions are discarded when aggregating over
subperiods.

An optional vector of weights can be specified when aggregating index values
over subperiods, which is often useful when aggregating a Paasche index; see
section 4.3 of Balk (2008) for details.
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

epr <- with(prices, elemental_index(rel, period, ea))

mean(epr, window = 2)

}
\references{
Balk, B. M. (2008). \emph{Price and Quantity Index Numbers}.
Cambridge University Press.
}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}()},
\code{\link{as.data.frame.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{vcov.aggregate_piar_index}()}
}
\concept{index methods}
