test_that("Cache works as expected", {
    cache <- Cache$new()
    expect_false(cache$exists("foo"))
    expect_true(is.key_missing(cache$get("foo")))
    cache$set("foo", 4L)
    cache$set("bar", 2L)
    expect_true(cache$exists("foo"))
    expect_false(is.key_missing(cache$get("foo")))
    expect_equal(cache$get("foo"), 4L)
    expect_equal(cache$size(), 2L)
    expect_equal(cache$keys(), c("foo", "bar"))
    cache$remove("bar")
    expect_equal(cache$size(), 1L)
    cache$reset()
    expect_equal(cache$size(), 0L)
})
