% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oldFunctions.R
\name{sem.fit}
\alias{sem.fit}
\title{sem.fit}
\usage{
sem.fit(modelList, data, conditional = FALSE, corr.errors = NULL,
  add.vars = NULL, grouping.vars = NULL, grouping.fun = mean,
  adjust.p = FALSE, basis.set = NULL, pvalues.df = NULL,
  model.control = NULL, .progressBar = TRUE)
}
\arguments{
\item{modelList}{a \code{list} of regressions representing the structural equation model}

\item{data}{a \code{data.frame} used to construct the structured equations}

\item{conditional}{whether the full set of conditioning variables should be returned.
Default is \code{FALSE}}

\item{corr.errors}{a vector of variables with correlated errors (separated by "~~")}

\item{add.vars}{a vector of additional variables whose independence claims should be 
evaluated, but which do not appear in the model list}

\item{grouping.vars}{an optional variable that represents the levels of data aggregation 
for a multi-level dataset}

\item{grouping.fun}{a function defining how variables are aggregated in \code{grouping.vars}. 
Default is \code{mean}}

\item{adjust.p}{whether p-values degrees of freedom should be adjusted. Default is \code{FALSE}}

\item{basis.set}{provide an optional basis set}

\item{pvalues.df}{an optional \code{data.frame} corresponding to p-values for independence claims}

\item{model.control}{a \code{list} of model control arguments to be passed to d-sep models}

\item{.progressBar}{enable optional text progress bar. Default is \code{TRUE}}
}
\value{
a \code{list} corresponding to: the tests of directed separation, the Fisher's C statistic,
and the AIC of the model
}
\description{
Goodness-of-fit tests for piecewise SEM (old)
}
\details{
Tests independence claims and calculates Fisher's C statistic and associated p-value, and AIC
and AICc, for a piecewise structural equation model (SEM).
}
