% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_track.R
\name{pb_track}
\alias{pb_track}
\title{Track data files of a given pattern or location}
\usage{
pb_track(glob = NULL, repo_root = usethis::proj_get())
}
\arguments{
\item{glob}{vector of file names and/or glob pattern (e.g. \code{*.csv}, \code{data/*.csv})
which will be tracked by piggyback.  Omit (default \code{NULL}) to just return
a list of files currently tracked.}

\item{repo_root}{repository root, will be guessed by \code{usethis} otherwise.}
}
\value{
list of tracked files (invisibly)
}
\description{
Track data files of a given pattern or location
}
\details{
Note: tracked patterns are simply written to \code{.pbattributes}
(analogous to \code{.gitattributes} in \code{git-lfs}.)  You can also edit this
file manually.  You will probably want to check in \code{.psattributes} to
as to version control., with \code{git add .psattributes}.  Note that
tracked file patterns will also be added to \code{.gitignore}.
}
\examples{
\dontrun{
## Track all .csv and .tsv files
pb_track(c("*.tsv", "*.tsv.gz"))

}
}
