% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{generateReferenceSet}
\alias{generateReferenceSet}
\title{Generate allele similarity reference set}
\usage{
generateReferenceSet(
  germline_distance,
  germline_set,
  alleleClusterTable,
  trim_3prime_side = NULL
)
}
\arguments{
\item{germline_distance}{A germline set distance matrix created by \link{ighvDistance}.}

\item{germline_set}{A character list of the IMGT aligned IGHV allele sequences. See details for curating options.}

\item{alleleClusterTable}{A data.frame of the alleles and their clusters created by \link{ighvClust}.}

\item{trim_3prime_side}{If a 3' position trim is supplied, duplicated sequences will be checked for differential positions past the trim position. Default NULL; NULL will not activate the check. see @details}
}
\value{
A \code{list} with the re-named germline set, and a table of the allele clusters and thresholds.
}
\description{
Generates the allele clusters reference set based on the clustering from \link{ighvClust}. The function collapse
similar alleles and assign them into their respective allele clusters and family clusters. See details for naming scheme
}
\details{
Each allele is named by this scheme:
IGHVF1-G1*01 - IGH = chain, V = region, F1 = family cluster numbering,
G1 - allele cluster numbering, and 01 = allele numbering (given by clustering order, no connection to the expression)

In case there are alleles that are differentiated in a nucleotide position past the trimming position used for the clustering,
then the alleles are separated and are annotated with the differentiating position as so:
Say A1\emph{01 and A1}02 are similar up to position 318, and thus collapsed in the clusters to G1\emph{01.
Upon checking the sequences past the trim position (318), a differentiating nucleotide was seen in position 319,
A1}01 has a G, and A1\emph{02 has a T.
Then the alleles will be separated, and the new annotation will be as so:
A1}01 = G1\emph{01, and A1}02 = G1*01_G319T.
Where the first nucleotide indicate the base, the following number the position, and the last nucleotide the one the base changed into.
}
