% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-format-header.R
\name{tbl_format_header}
\alias{tbl_format_header}
\title{Format the header of a tibble}
\usage{
tbl_format_header(x, setup, ...)
}
\arguments{
\item{x}{A tibble-like object.}

\item{setup}{A setup object returned from \code{\link[=tbl_format_setup]{tbl_format_setup()}}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A character vector.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

For easier customization, the formatting of a tibble is split
into three components: header, body, and footer.
The \code{tbl_format_header()} method is responsible for formatting the header
of a tibble.

Override this method if you need to change the appearance
of the entire header.
If you only need to change or extend the components shown in the header,
override or extend \code{\link[=tbl_sum]{tbl_sum()}} for your class which is called by the
default method.
}
\examples{
\dontshow{if (requireNamespace("palmerpenguins", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
setup <- tbl_format_setup(palmerpenguins::penguins)
tbl_format_header(palmerpenguins::penguins, setup)

# Shortcut for debugging
tbl_format_header(setup)
\dontshow{\}) # examplesIf}
}
