% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_connect_url.R
\name{board_connect_url}
\alias{board_connect_url}
\alias{connect_auth_headers}
\title{Use a vector of Posit Connect vanity URLs as a board}
\usage{
board_connect_url(
  vanity_urls,
  cache = NULL,
  use_cache_on_failure = is_interactive(),
  headers = connect_auth_headers()
)

connect_auth_headers(key = Sys.getenv("CONNECT_API_KEY"))
}
\arguments{
\item{vanity_urls}{A named character vector of
\href{https://docs.posit.co/connect/user/content-settings/#custom-url}{Connect vanity URLs}.
This board is read only, and the best way to write to a pin on Connect is
\code{\link[=board_connect]{board_connect()}}.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{use_cache_on_failure}{If the pin fails to download, is it ok to
use the last cached version? Defaults to \code{is_interactive()} so you'll
be robust to poor internet connectivity when exploring interactively,
but you'll get clear errors when the code is deployed.}

\item{headers}{Named character vector for additional HTTP headers (such as for
authentication). See \code{\link[=connect_auth_headers]{connect_auth_headers()}} for Posit Connect support.}

\item{key}{The Posit Connect API key.}
}
\description{
\code{board_connect_url()} lets you build up a board from individual
\href{https://docs.posit.co/connect/user/content-settings/#custom-url}{vanity urls}.

\code{board_connect_url()} is read only, and does not support versioning.
}
\details{
This board is a thin wrapper around \code{\link[=board_url]{board_url()}} which uses
\code{connect_auth_headers()} for authentication via environment variable.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
connect_auth_headers()

board <- board_connect_url(c(
    my_vanity_url_pin = "https://colorado.posit.co/rsc/great-numbers/"
))

board \%>\% pin_read("my_vanity_url_pin")
\dontshow{\}) # examplesIf}
}
\seealso{
Other boards: 
\code{\link{board_connect}()},
\code{\link{board_folder}()},
\code{\link{board_url}()}
}
\concept{boards}
