% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.R
\name{loss_flux}
\alias{loss_flux}
\alias{flux_loss}
\title{Convert heat flux to specific heat loss power}
\usage{
loss_flux(x, d, wth = 0)

flux_loss(x, d, wth = 0)
}
\arguments{
\item{x}{value of
\itemize{
  \item \emph{heat flux}, [\emph{W/m^2}], for \code{loss_flux(x, d, wth)}
  \item \emph{specific heat loss power}, [\emph{kcal/m/h}], for \code{flux_loss(x, d, wth)(x)}
}
Type: \code{\link{assert_double}}.}

\item{d}{outside (if \emph{wth = 0}) or internal (if \emph{wth > 0}) diameter of cylindrical pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{wth}{wall thickness of pipe, [\emph{mm}], or \emph{0} if argument \emph{d} is an outside diameter of pipe.
Type: \code{\link{assert_double}}.}
}
\value{
value of
 \itemize{
   \item \emph{specific heat loss power}, [\emph{kcal/m/h}], for \code{loss_flux(x, d, wth)}
   \item \emph{heat flux}, [\emph{W/m^2}], for \code{flux_loss(x, d, wth)(x)}
 }
 Type: \code{\link{assert_double}}.
}
\description{
Convert \href{https://en.wikipedia.org/wiki/Heat_flux}{heat flux}
 measured for a cylindrical steel pipe to \emph{specific heat loss power} of pipe.
}
\examples{
library(pipenostics)

# Consider pipes:
diameter      <- c(998, 1395)  # [mm]
wall_thikness <- c(  2,    5)  # [mm]

# Then maximum possible normative neat loss according (Minenergo-325) for
# these pipe diameters are
loss_max <- c(218, 1040)  # [kcal/m/h]

# The appropriate flux is
flux <- flux_loss(loss_max, diameter * 1e-3, wall_thikness)
print(flux)

# [1] 80.70238 275.00155  # [W/m^2]

stopifnot(
  all.equal(loss_flux(flux, diameter * 1e-3, wall_thikness), loss_max, tolerance = 5e-6)
)


}
\seealso{
Other units: 
\code{\link{c_k}()},
\code{\link{f_k}()},
\code{\link{inch_mm}()},
\code{\link{k_c}()},
\code{\link{kgf_mpa}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()},
\code{\link{psi_mpa}()}
}
\concept{units}
