% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fric_vatankhan.R
\name{fric_vatankhan}
\alias{fric_vatankhan}
\title{Estimate pipe friction factor with Vatankhah formula}
\usage{
fric_vatankhan(reynolds, roughness = 0, strict = FALSE)
}
\arguments{
\item{reynolds}{Reynolds number, []. Type: \code{\link{assert_double}}.}

\item{roughness}{relative roughness, []. Type: \code{\link{assert_double}}.}

\item{strict}{calculate only inside the precision region. Type: \code{\link{assert_flag}}.}
}
\value{
pipe friction factor, []. Type: \code{\link{assert_double}}.
}
\description{
Estimate \emph{Darcy friction factor} explicitly with extremely accurate
 \emph{Vatankhah-Kouchakzadeh} approximation of \emph{Colebrook equation}.
}
\details{
Vatankhah's formula is reported to be extremely accurate in the region:
 \itemize{
   \item \code{5.0e3 <= reynolds  <= 1.0e8}
   \item \code{1e-6  <= roughness <= 0.05}
 }

 In \code{strict = TRUE} mode argument values outside this precision region
 are not allowed, whereas in \code{strict = FALSE} either \emph{NA}s are
 generated in that case or calculation for laminar flow is performed when
 \code{reynolds < 2100.0}.
}
\examples{
 library(pipenostics)

 fric_vatankhan(c(2118517, 2000, 2118517), c(1e-6, 70e-3/1, 7e-3/1))
 # [1] 0.01031665 0.03200000 0.03375210  # []

 fric_vatankhan(c(2118517, 5500, 2118517), c(1e-6, 50e-3/1, 7e-3/1), TRUE)
 # [1] 0.01031665 0.07556163 0.03375210
}
\references{
\enumerate{
     \item Offor, U. and Alabi, S. (2016) \emph{An Accurate and Computationally Efficient Explicit Friction Factor Model}.
 Advances in Chemical Engineering and Science, \emph{6}, pp. 237-245. \doi{10.4236/aces.2016.63024}.

     \item Ali R. Vatankhah, Salah Kouchakzadeh (2009) \emph{Exact equations for pipe-flow problems}.
 Journal of Hydraulic Research, \emph{47:4}, pp. 537-538, DOI: \doi{10.1080/00221686.2009.9522031}
  }
}
\seealso{
Other Fluid properties: 
\code{\link{fric_buzelli}()},
\code{\link{fric_romeo}()},
\code{\link{re_u}()}
}
\concept{Fluid properties}
