% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_pvalue.R
\name{permute_pvalue}
\alias{permute_pvalue}
\title{Calculation of permutation p-value}
\usage{
permute_pvalue(dat, permuteN, method = "F")
}
\arguments{
\item{dat}{Data frame with first column as the treatment index, second column as the outcome, and the 
remaining columns as the covariates design matrix. The elements of the treatment index take \eqn{K} distinct values, where \eqn{K} is the number of treatment groups. 
The outcome has to be a continuous variable.}

\item{permuteN}{Number of permutation}

\item{method}{Choice of the criterion that the generated effect modifier optimizes. This is a string in 
\code{c("nu","de","F")}, which corresponde to the numerator, denominator and F-statistics
criteria respectively. The default method is the F-statistics method.}
}
\value{
\code{perm_p} Permutation p-value for the data and choosen criterior

\code{p} A vector of calculated p-value for the original and permuted data set under the choosen criterior
}
\description{
Calculates the permutation p-value for a fitted GEM. See more detail in \cite{E Petkova, T Tarpey, Z Su, and RT Ogden. Generated effect modifiers (GEMs) in randomized clinical trials. Biostatistics, (First published online: July 27, 2016). doi: 10.1093/biostatistics/kxw035.}
}
\examples{
#constructing the covariance matrix
co <- matrix(0.2, 10, 10)
diag(co) <- 1
#simulate a data set
dataEx <- data_generator1(d = 0.3, R2 = 0.5, v2 = 1, n = 300,
                        co = co, beta1 = rep(1,10),inter = c(0,0))
#calculate the permuted p value
dat <- dataEx[[1]]
permute_pvalue(dat, permuteN = 200, method = "nu")
}

