% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_exemplary_dd_tree_giappo.R
\name{create_exemplary_dd_tree_giappo}
\alias{create_exemplary_dd_tree_giappo}
\title{Create an exemplary diversity-dependent (DD) birth-death tree.}
\usage{
create_exemplary_dd_tree_giappo(
  n_taxa = 6,
  crown_age = 10,
  extinction_rate = 0.1,
  best_of_n_trees = 100
)
}
\arguments{
\item{n_taxa}{number of tree tips}

\item{crown_age}{the fixed crown age of the posterior. Set to NA
to let it be estimated}

\item{extinction_rate}{per-species extinction rate}

\item{best_of_n_trees}{simulate this number of DD trees with
the desired number of taxa,}
}
\value{
a \link[ape]{phylo}
}
\description{
Or: create a DD tree with a strong DD effect.
}
\details{
This algorithm does so, by simulating \code{best_of_n_trees}
trees, then picks the tree that has the gamma statistic furthest
away from zero.
Trees with such a gamma statistic, have the strongest DD effect, as these
deviate strongest from the expected exponential growth
that regular birth-death (BD) trees have.
}
\examples{

n_taxa <- 3
crown_age <- 1

phylogeny <- create_exemplary_dd_tree(
  n_taxa = n_taxa,
  crown_age = crown_age
)
}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
