% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tral_file.R
\name{create_tral_file}
\alias{create_tral_file}
\title{Simulates a DNA alignment and saves it to a FASTA file.}
\usage{
create_tral_file(phylogeny, alignment_params, verbose = FALSE)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{alignment_params}{parameters to simulate an alignment,
as can be created by \link{create_alignment_params}}

\item{verbose}{if TRUE, show more output}
}
\value{
nothing
}
\description{
The simulation is performed by \link{create_true_alignment}.
}
\examples{

# Create the ancestor's DNA sequence
n_base_pairs <- 4
root_sequence <- create_blocked_dna(length = n_base_pairs)

# How to simulate (and where to save) the alignment
alignment_params <- create_alignment_params(
  root_sequence = root_sequence
)

# Create a phylogeny to simulate the DNA sequences on
n_taxa <- 5
phylogeny <- ape::rcoal(n_taxa)

# Simulate and save the alignment
create_tral_file(
  phylogeny = phylogeny,
  alignment_params = alignment_params
)
}
\seealso{
Use \link{create_true_alignment} to only simulate the alignment,
  without saving the alignment to file
}
\author{
Richèl J.C. Bilderbeek
}
