% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_alignment_params.R
\name{create_test_alignment_params}
\alias{create_test_alignment_params}
\title{Create testing parameters for the alignment simulation.}
\usage{
create_test_alignment_params(
  sim_tral_fun = pirouette::sim_tral_with_std_nsm,
  root_sequence = "acgt",
  rng_seed = 0,
  fasta_filename = pirouette::get_temp_fasta_filename()
)
}
\arguments{
\item{sim_tral_fun}{function to simulate a
true alignment with.
This function must have two arguments,
called \code{true_phylogeny} (which will hold the true phylogeny)
and \code{root_sequence} (which holds the DNA root sequence).
The return type must be \link[ape]{DNAbin}.

Use \link{check_sim_tral_fun} to verify if the function
has the right signature and output.

Some standard functions:\cr
\itemize{
  \item Use \link{get_sim_tral_with_std_nsm_fun}
  to get a function (\link{sim_tral_with_std_nsm})
  the use a standard site model.
  \item Use
  \link{get_sim_tral_with_lns_nsm_fun}
  to get a function
  (\link{sim_tral_with_lns_nsm})
  the use a linked node substitution site model.
  \item Use
  \link{get_sim_tral_with_uns_nsm_fun}
  to get a function
  (\link{sim_tral_with_uns_nsm})
  the use an unlinked node substitution site model.
}}

\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}

\item{rng_seed}{a random number generator seed}

\item{fasta_filename}{name of a FASTA file.
Use \link{get_alignment_id} to get the ID of the alignment}
}
\value{
a list of alignment parameters
alignment_params <- create_test_alignment_params()
check_alignment_params(alignment_params)
}
\description{
Create testing parameters for the alignment simulation.
}
\author{
Richèl J.C. Bilderbeek
}
