% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_run.R
\name{pir_run}
\alias{pir_run}
\title{Measure the error BEAST2 makes from a known phylogeny.}
\usage{
pir_run(
  phylogeny,
  pir_params = create_pir_params(alignment_params = create_alignment_params(),
    twinning_params = create_twinning_params())
)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{pir_params}{the parameters of \link[pirouette]{pirouette}.
They are created by \link{create_pir_params}.}
}
\value{
a data frame with errors, with as many rows as model selection
parameter sets. The output can be checked using \link{check_pir_out}.
}
\description{
From a phylogeny of (un)known speciation model,
an alignment is created using a known site model and clock model,
as given by \code{alignment_params}.
}
\examples{
if (beautier::is_on_ci()) {

  phylogeny <- ape::read.tree(text = "(((A:1, B:1):1, C:2):1, D:3);")
  pir_params <- create_test_pir_params()

  errors <- NA
  if (
    rappdirs::app_dir()$os != "win" &&
    beastier::is_beast2_installed()
  ) {
    pir_run(
      phylogeny = phylogeny,
      pir_params = pir_params
    )
  } else {
    create_test_pir_run_output()
  }
}
}
\seealso{
\itemize{
  \item Use \link{pir_plot} to display the output of \link{pir_run} as a
    figure.
  \item Use \link{create_test_pir_run_output} to create a test output
    of \link{pir_run}.
  \item Use \link{pir_runs} to do multiple \link{pirouette} runs.
}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
