% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_map}
\alias{async_map}
\title{Apply an asynchronous function to each element of a vector}
\usage{
async_map(.x, .f, ..., .args = list(), .limit = Inf)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{Asynchronous function to apply.}

\item{...}{Additional arguments to \code{.f}.}

\item{.args}{More additional arguments to \code{.f}.}

\item{.limit}{Number of elements to process simulateneously.}
}
\value{
Deferred value that is resolved after all deferred values
from the application of \code{.f} are resolved.
}
\description{
Apply an asynchronous function to each element of a vector
}
\examples{
synchronise(async_map(
  seq(10, 100, by = 10) / 100,
  function(wait) delay(wait)$then(function() "OK")
))
}
\seealso{
Other async iterators: \code{\link{async_detect}},
  \code{\link{async_every}}, \code{\link{async_filter}}
}
\concept{async iterators}
