% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_whilst}
\alias{async_whilst}
\title{Repeatedly call task, while test returns true}
\usage{
async_whilst(test, task, ...)
}
\arguments{
\item{test}{Synchronous test function.}

\item{task}{Asynchronous function to call repeatedly.}

\item{...}{Arguments to pass to \code{task}.}
}
\value{
Deferred value, that is resolved when the iteration is done.
}
\description{
Repeatedly call task, while test returns true
}
\examples{
## Keep calling while result is bigger than 0.1
calls <- 0
number <- Inf
synchronise(async_whilst(
  function() number >= 0.1,
  function() {
    calls <<- calls + 1
    number <<- runif(1)
  }
))
calls
}
\seealso{
Other async control flow: \code{\link{async_reflect}},
  \code{\link{async_retryable}}, \code{\link{async_retry}},
  \code{\link{async_sequence}},
  \code{\link{async_try_each}}, \code{\link{async_until}}
}
\concept{async control flow}
