% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_retryable}
\alias{async_retryable}
\title{Make an asynchronous funcion retryable}
\usage{
async_retryable(task, times)
}
\arguments{
\item{task}{An asynchronous function.}

\item{times}{Number of tries.}
}
\value{
Asynchronous retryable function.
}
\description{
Make an asynchronous funcion retryable
}
\examples{
\donttest{
## Create a downloader that retries five times
http_get_5 <- async_retryable(http_get, times = 5)
ret <- synchronise(
  http_get_5("https://eu.httpbin.org/get?q=1")$
    then(function(x) rawToChar(x$content))
)
cat(ret)
}
}
\seealso{
Other async control flow: \code{\link{async_reflect}},
  \code{\link{async_retry}}, \code{\link{async_sequence}},
  \code{\link{async_try_each}}, \code{\link{async_until}},
  \code{\link{async_whilst}}
}
\concept{async control flow}
