% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-dependencies.R
\name{new_pkg_deps}
\alias{new_pkg_deps}
\alias{pkg_deps}
\title{R6 class for package dependency lookup}
\usage{
new_pkg_deps(refs, ...)
}
\arguments{
\item{refs}{Package names or references. See
\link[=pkg_refs]{'Package references'} for the syntax.}

\item{...}{Additional arguments, passed to
\href{#method-new}{\code{pkg_deps$new()}}.}
}
\value{
\code{new_pkg_deps()} returns a new \code{pkg_deps} object.
}
\description{
Look up dependencies of R packages from various sources.
}
\details{
\code{new_pkg_deps()} creates a new object from the \code{pkg_deps} class.
The advantage of \code{new_pkg_deps()} compared to using the \link{pkg_deps}
constructor directly is that it avoids making pkgdepends a build time
dependency.

The usual steps to query package dependencies are:
\enumerate{
\item Create a \code{pkg_deps} object with \code{new_pkg_deps()}.
\item Resolve all possible dependencies with
\href{#method-resolve}{\code{pkg_deps$resolve()}}.
\item Solve the dependencies, to obtain a subset of all possible
dependencies that can be installed together, with
\href{#method-solve}{\code{pkg_deps$solve()}}.
\item Call \href{#method-get-solution}{\code{pkg_deps$get_solution()}} to list the
result of the dependency solver.
}
}
\examples{

## ------------------------------------------------
## Method `pkg_deps$new`
## ------------------------------------------------

pd <- pkg_deps$new("r-lib/pkgdepends")
pd

## ------------------------------------------------
## Method `pkg_deps$get_refs`
## ------------------------------------------------

pd <- new_pkg_deps(c("pak", "jsonlite"))
pd$get_refs()

## ------------------------------------------------
## Method `pkg_deps$get_config`
## ------------------------------------------------

pd <- new_pkg_deps("pak")
pd$get_config()

## ------------------------------------------------
## Method `pkg_deps$resolve`
## ------------------------------------------------

\dontrun{
pd <- new_pkg_deps("pak")
pd$resolve()
pd$get_resolution()
}

## ------------------------------------------------
## Method `pkg_deps$get_resolution`
## ------------------------------------------------

\dontrun{
pd <- new_pkg_deps("r-lib/pkgdepends")
pd$resolve()
pd$get_resolution()
}

## ------------------------------------------------
## Method `pkg_deps$get_solve_policy`
## ------------------------------------------------

pdi <- new_pkg_deps("r-lib/pkgdepends")
pdi$get_solve_policy()
pdi$set_solve_policy("upgrade")
pdi$get_solve_policy()

## ------------------------------------------------
## Method `pkg_deps$set_solve_policy`
## ------------------------------------------------

pdi <- new_pkg_deps("r-lib/pkgdepends")
pdi$get_solve_policy()
pdi$set_solve_policy("upgrade")
pdi$get_solve_policy()

## ------------------------------------------------
## Method `pkg_deps$solve`
## ------------------------------------------------

\dontrun{
pd <- new_pkg_deps("r-lib/pkgdepends")
pd$resolve()
pd$solve()
pd$get_solution()
}

## ------------------------------------------------
## Method `pkg_deps$get_solution`
## ------------------------------------------------

\dontrun{
pd <- new_pkg_deps("pkgload")
pd$resolve()
pd$solve()
pd$get_solution()
}

## ------------------------------------------------
## Method `pkg_deps$stop_for_solution_error`
## ------------------------------------------------

\dontrun{
# This is an error, because the packages conflict:
pd <- new_pkg_deps(
  c("r-lib/pak", "cran::pak"),
  config = list(library = tempfile())
)
pd$resolve()
pd$solve()
pd
# This fails:
# pd$stop_for_solution_error()
}

## ------------------------------------------------
## Method `pkg_deps$draw`
## ------------------------------------------------

\dontrun{
pd <- new_pkg_deps("pkgload")
pd$solve()
pd$draw()
}

## ------------------------------------------------
## Method `pkg_deps$print`
## ------------------------------------------------

\dontrun{
pd <- new_pkg_deps("r-lib/pkgdepends")
pd

pd$resolve()
pd

pd$solve()
pd
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pkg_deps$new()}}
\item \href{#method-get_refs}{\code{pkg_deps$get_refs()}}
\item \href{#method-get_config}{\code{pkg_deps$get_config()}}
\item \href{#method-resolve}{\code{pkg_deps$resolve()}}
\item \href{#method-async_resolve}{\code{pkg_deps$async_resolve()}}
\item \href{#method-get_resolution}{\code{pkg_deps$get_resolution()}}
\item \href{#method-get_solve_policy}{\code{pkg_deps$get_solve_policy()}}
\item \href{#method-set_solve_policy}{\code{pkg_deps$set_solve_policy()}}
\item \href{#method-solve}{\code{pkg_deps$solve()}}
\item \href{#method-get_solution}{\code{pkg_deps$get_solution()}}
\item \href{#method-stop_for_solution_error}{\code{pkg_deps$stop_for_solution_error()}}
\item \href{#method-draw}{\code{pkg_deps$draw()}}
\item \href{#method-format}{\code{pkg_deps$format()}}
\item \href{#method-print}{\code{pkg_deps$print()}}
\item \href{#method-clone}{\code{pkg_deps$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{pkg_deps} object. Consider using \code{new_pkg_deps()}
instead of calling the constructor directly.

The returned object can be used to look up (recursive) dependencies
of R packages from various sources. To perform the actual lookup,
you'll need to call the \href{#method-resolve}{\code{resolve()}} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$new(
  refs,
  config = list(),
  policy = c("lazy", "upgrade"),
  remote_types = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{refs}}{Package names or references. See
\link[=pkg_refs]{'Package references'} for the syntax.}

\item{\code{config}}{Configuration options, a named list. See
\link[=pkg_config]{'Configuration'}.}

\item{\code{policy}}{Solution policy. See \link[=pkg_solution]{'The dependency solver'}.}

\item{\code{remote_types}}{Custom remote ref types, this is for advanced
use, and experimental currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pkg_deps} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pd <- pkg_deps$new("r-lib/pkgdepends")
pd
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_refs"></a>}}
\if{latex}{\out{\hypertarget{method-get_refs}{}}}
\subsection{Method \code{get_refs()}}{
The package refs that were used to create the \code{pkg_deps} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$get_refs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of package refs that were used to create the
\code{pkg_deps} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pd <- new_pkg_deps(c("pak", "jsonlite"))
pd$get_refs()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_config"></a>}}
\if{latex}{\out{\hypertarget{method-get_config}{}}}
\subsection{Method \code{get_config()}}{
Configuration options for the \code{pkg_deps} object. See
\link[=pkg_config]{'Configuration'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$get_config()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list. See \link[=pkg_config]{'Configuration'} for the configuration
options.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pd <- new_pkg_deps("pak")
pd$get_config()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resolve"></a>}}
\if{latex}{\out{\hypertarget{method-resolve}{}}}
\subsection{Method \code{resolve()}}{
Resolve the dependencies of the specified package references. This
usually means downloading metadata from CRAN and Bioconductor, unless
already cached, and also from GitHub if GitHub refs were included,
either directly or indirectly. See
\link[=pkg_resolution]{'Dependency resolution'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$resolve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{pkg_deps} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pd <- new_pkg_deps("pak")
pd$resolve()
pd$get_resolution()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-async_resolve"></a>}}
\if{latex}{\out{\hypertarget{method-async_resolve}{}}}
\subsection{Method \code{async_resolve()}}{
The same as \href{#method-resolve}{\code{resolve()}}, but asynchronous.
This method is for advanced use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$async_resolve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A deferred value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_resolution"></a>}}
\if{latex}{\out{\hypertarget{method-get_resolution}{}}}
\subsection{Method \code{get_resolution()}}{
Query the result of the dependency resolution. This method can be
called after \href{#method-resolve}{\code{resolve()}} has completed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$get_resolution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{pkg_resolution_result} object, which is also a tibble. See
\link[=pkg_resolution]{'Dependency resolution'} for its columns.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pd <- new_pkg_deps("r-lib/pkgdepends")
pd$resolve()
pd$get_resolution()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_solve_policy"></a>}}
\if{latex}{\out{\hypertarget{method-get_solve_policy}{}}}
\subsection{Method \code{get_solve_policy()}}{
Returns the current policy of the dependency solver.
See \link[=pkg_solution]{'The dependency solver'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$get_solve_policy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of length one.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pdi <- new_pkg_deps("r-lib/pkgdepends")
pdi$get_solve_policy()
pdi$set_solve_policy("upgrade")
pdi$get_solve_policy()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_solve_policy"></a>}}
\if{latex}{\out{\hypertarget{method-set_solve_policy}{}}}
\subsection{Method \code{set_solve_policy()}}{
Set the current policy of the dependency solver.
If the object already contains a solution and the new policy is
different than the old policy, then the solution is deleted.
See \link[=pkg_solution]{'The dependency solver'} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$set_solve_policy(policy = c("lazy", "upgrade"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{policy}}{Policy to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{pdi <- new_pkg_deps("r-lib/pkgdepends")
pdi$get_solve_policy()
pdi$set_solve_policy("upgrade")
pdi$get_solve_policy()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-solve"></a>}}
\if{latex}{\out{\hypertarget{method-solve}{}}}
\subsection{Method \code{solve()}}{
Solve the package dependencies. Out of the resolved dependencies, it
works out a set of packages, that can be installed together to
create a functional installation. The set includes all directly
specified packages, and all required (or suggested, depending on
the configuration) packages as well. It includes every package at
most once. See \link[=pkg_solution]{'The dependency solver'} for details.

\code{solve()} calls \href{#method-resolve}{\code{resolve()}} automatically, if it
hasn't been called yet.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$solve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{pkg_deps} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pd <- new_pkg_deps("r-lib/pkgdepends")
pd$resolve()
pd$solve()
pd$get_solution()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_solution"></a>}}
\if{latex}{\out{\hypertarget{method-get_solution}{}}}
\subsection{Method \code{get_solution()}}{
Returns the solution of the package dependencies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$get_solution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{pkg_solution_result} object, which is a list. See
\link{pkg_solution_result} for details.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pd <- new_pkg_deps("pkgload")
pd$resolve()
pd$solve()
pd$get_solution()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop_for_solution_error"></a>}}
\if{latex}{\out{\hypertarget{method-stop_for_solution_error}{}}}
\subsection{Method \code{stop_for_solution_error()}}{
Error if the dependency solver failed to find a consistent set of
packages that can be installed together.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$stop_for_solution_error()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# This is an error, because the packages conflict:
pd <- new_pkg_deps(
  c("r-lib/pak", "cran::pak"),
  config = list(library = tempfile())
)
pd$resolve()
pd$solve()
pd
# This fails:
# pd$stop_for_solution_error()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-draw"></a>}}
\if{latex}{\out{\hypertarget{method-draw}{}}}
\subsection{Method \code{draw()}}{
Draw a tree of package dependencies. It returns a \code{tree} object, see
\code{\link[cli:tree]{cli::tree()}}. Printing this object prints the dependency tree to the
screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$draw()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{tree} object from the cli package, see \code{\link[cli:tree]{cli::tree()}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pd <- new_pkg_deps("pkgload")
pd$solve()
pd$draw()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Format a \code{pkg_deps} object, typically for printing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector, each element should be a line in the printout.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints a \code{pkg_deps} object to the screen. The printout includes:
\itemize{
\item The package refs.
\item Whether the object has the resolved dependencies.
\item Whether the resolution had errors.
\item Whether the object has the solved dependencies.
\item Whether the solution had errors.
\item Advice on which methods to call next.
}

See the example below.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used currently.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{pkg_deps} object itself, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
pd <- new_pkg_deps("r-lib/pkgdepends")
pd

pd$resolve()
pd

pd$solve()
pd
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pkg_deps$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
