% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh-releases.R
\name{ghr}
\alias{ghr}
\title{GitHub Releases}
\description{
Functions to query and manipulate GitHub releases. These functions are
currently experimental.
}
\details{
\subsection{List releases}{
\subsection{Description}{

\code{ghr$list()} lists the last 100 releases for a GitHub repository.
\code{ghr$async_list()} is the async version of \code{ghr$list()}.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{ghr$list(repo)
ghr$async_list(repo)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{repo}: repository slug, e.g. \code{"cran/cli"}.
}
}

\subsection{Value}{

Data frame with columns:
\itemize{
\item \code{id}: release id,
\item \code{name}: release name, usually the version number, possibly with
a \code{v} prefix: \verb{3.6.1} or \code{v3.6.1}, but can be different.
\item \code{tag_name}: usually the same as \code{name}.
\item \code{created_at}: \code{POSIXct} vector.
}
}

}

\subsection{Get information about a release}{
\subsection{Description}{

\code{ghr$get()} downloads information about a release, including
release assets.

\code{ghr$async_get} is the async version of \code{ghr$get}.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{ghr$get(repo, tag)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{repo}: repository slug, e.g. \code{"cran/cli"}.
\item \code{tag}: tag to get.
}
}

\subsection{Value}{

Named list, see
\url{https://docs.github.com/en/rest/releases/releases#get-a-release}
for the entries.
}

}

\subsection{List assets of a release}{
\subsection{Description}{

\code{ghr$list_assets()} lists the last 100 assets of a release.

\code{ghr$async_list_assets()} is the async version of \code{ghr$list_assets()}
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{ghr$list_assets(repo, tag)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{repo}: repository slug, e.g. \code{"cran/cli"}.
\item \code{tag}: tag to query.
}
}

\subsection{Value}{

Data frame with columns:
\itemize{
\item \code{id}: asset id,
\item \code{name}: file name of the asset,
\item \code{download_url}: download URL,
\item \code{size}: size in bytes,
\item \code{created_at}: \code{POSIXct} vector,
\item \code{updated_at}: \code{POSXct} vector,
\item \code{content_type}: content type of asset.
}
}

}

\subsection{Add a release asset}{
\subsection{Description}{

\code{ghr$add_asset()} adds an asset to a GitHub release.

\code{ghr$async_add_asset()} is the async version of \code{ghr$add_asset()}.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{ghr\%add_asset(repo, file, tag, name = basename(file))
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{repo}: repository slug, e.g. \code{cran/cli}.
\item \code{file}: path to file to upload as an asset.
\item \code{tag}: tag name to add the asset to. It must exist on GitHub.
\item \code{name}: file name of the asset in the release.
}
}

\subsection{Details}{

If an asset with the same name already exists, then that will be deleted
first.
}

\subsection{Value}{

Response from GitHub as a named list. See
\url{https://docs.github.com/en/rest/releases/assets#upload-a-release-asset}
for the structure.
}

}

\subsection{Delete a release asset}{
\subsection{Description}{

\code{ghr$delete_asset()} deleted a release asset.

\code{ghr$async_delete_asset()} is an async version of \code{ghr$delete_asset()}.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{ghr$delete_asset(repo, tag, name)
ghr$async_delete_asset(repo, tag, name)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{repo}: repository slug, e.g. \code{cran/cli}.
\item \code{tag}: tag name to create a release for. It must exist on GitHub.
\item \code{name}: name of the asset.
}
}

\subsection{Value}{

A list with entries:
\itemize{
\item \code{release}: a list with the data about the release, before the
deletion. It has the same format as the return value of \code{ghr$get()}.
\item \code{deleted}: \code{TRUE} if the asset was deleted. \code{FALSE} if the asset
did not exist.
}
}

}

\subsection{Create a GitHub release}{
\subsection{Description}{

\code{ghr$create()} creates a GitHub release from a tag.

\code{ghr$async_create()} is an async version of \code{ghr$create()}.
}

\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{ghr$create(
  repo,
  tag,
  description = "",
  draft = FALSE,
  prerelease = FALSE,
  generage_release_notes = FALSE
)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{repo}: repository slug, e.g. \code{cran/cli}.
\item \code{tag}: tag name to create a release for. It must exist on GitHub.
\item \code{description}: release description.
\item \code{draft}: whether to create a draft release.
\item \code{prerelease}: whether to create a prerelease.
\item \code{generate_release_notes}: whether to auto-generate release notes.
}
}

\subsection{Value}{

Response from GitHub as a named list. See
\url{https://docs.github.com/en/rest/releases/releases#create-a-release}
for the structure.
}

}
}
\keyword{internal}
