% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_neighborhood.R
\name{get_neighborhood}
\alias{get_neighborhood}
\title{get_neighborhood}
\usage{
get_neighborhood(packages, level = 1L, relation = c("Depends", "Imports",
  "LinkingTo", "Suggests", "Enhances"), strict = FALSE, interconnect = TRUE,
  ignore = c("datasets", "utils", "grDevices", "graphics", "stats",
  "methods"))
}
\arguments{
\item{packages}{(non-empty character vector) Package names}

\item{level}{(positive integer, Default: 1L) Depth of recursive dependency}

\item{relation}{(character vector) Types of relations. Must be a subset of
c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}

\item{strict}{(logical, Default: TRUE) Whether to consider all packages
(alternately only 'relation' specific packages) when computing dependencies
for the next level}

\item{interconnect}{(flag, Default: TRUE) Whether to capture dependency among
packages (of a given level) of the next level (See examples)}

\item{ignore}{package names to ignore}
}
\value{
A tibble with three columns: `pkg_1`, `relation` and `pkg_2`
}
\description{
Obtain dependencies and reverse dependencies of packages at a
  given depth of recursion
}
\examples{
# explore first level dependencies
pkggraph::init(local = TRUE)
pkggraph::get_neighborhood("caret")

# explore second level dependencies
pkggraph::get_neighborhood("caret", level = 2)

# explore second level dependencies without
# considering dependencies from third level
pkggraph::get_neighborhood("caret", level = 2, interconnect = FALSE)

# explore first level dependencies of multiple packages
# and consider second level dependencies
get_neighborhood(c("caret", "mlr"))

# get 'imports' specific neighborhood of 'mlr' package with strict = TRUE
get_neighborhood("mlr"
                 , level        = 2
                 , strict       = TRUE
                 , interconnect = FALSE
                 , relation     = "Imports")

# get 'imports' specific neighborhood of 'mlr' package with strict = FALSE
get_neighborhood("mlr"
                 , level        = 2
                 , strict       = FALSE
                 , interconnect = FALSE
                 , relation     = "Imports")
}
\seealso{
\code{\link{neighborhood_graph}},
  \code{\link{make_neighborhood_graph}}
}
\author{
Srikanth KS
}
