% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_grid.R
\name{b_grid}
\alias{b_grid}
\title{Plots multiple b-scored normalised platemaps}
\usage{
b_grid(data, well, plate_id, plate = 96)
}
\arguments{
\item{data}{Numerical values to be plotted}

\item{well}{Vector of well identifiers e.g "A01"}

\item{plate_id}{Vector of plate identifiers e.g "Plate_1"}

\item{plate}{Number of wells in complete plate (96, 384 or 1536)}
}
\value{
ggplot plot
}
\description{
Transforms numerical values using the b-score normalisation process to
account for row and column effects. Uses well and plate labels to plot the
normalised values in the form of microtitre plates. Works for 96, 384 and
1536 well plates.
}
\examples{
df01 <- data.frame(well = num_to_well(1:96),
  vals = rnorm(96),
  plate = 1)

df02 <- data.frame(well = num_to_well(1:96),
  vals = rnorm(96),
  plate = 2)

df <- rbind(df01, df02)

b_grid(data = df$vals,
    well = df$well,
    plate_id = df$plate,
    plate = 96)
}
