% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_input}
\alias{mosaic_input}
\alias{mosaic_export}
\title{Create and Export mosaics}
\usage{
mosaic_input(mosaic, ...)

mosaic_export(mosaic, filename, overwrite = FALSE, ...)
}
\arguments{
\item{mosaic}{\itemize{
\item For \code{mosaic_input()}, a file path to the raster to imported, a matrix,
array or a list of \code{SpatRaster} objects.
\item For \code{mosaic_export()}, an \code{SpatRaster} object.
}}

\item{...}{Additional arguments passed to \code{\link[terra:rast]{terra::rast()}} (\code{mosaic_input()})
or  \code{\link[terra:writeRaster]{terra::writeRaster()}} (\code{mosaic_output()})}

\item{filename}{character. The Output filename.}

\item{overwrite}{logical. If \code{TRUE}, filename is overwritten.}
}
\value{
\itemize{
\item \code{mosaic_input()} returns an \code{SpatRaster} object.
\item \code{mosaic_export()} do not return an object.
}
}
\description{
Create and Export mosaics
}
\details{
\itemize{
\item \code{mosaic_input()} is a simply wrapper around \code{\link[terra:rast]{terra::rast()}}. It creates a
\code{SpatRaster} object from scratch, from a filename, or from another object.
\item \code{mosaic_export()} is a simply wrapper around \code{\link[terra:writeRaster]{terra::writeRaster()}}. It write
a \code{SpatRaster} object to a file.
}
}
\examples{
library(pliman)

# create an SpatRaster object based on a matrix
x <- matrix(1:20, nrow = 4, ncol = 5)
rast <- mosaic_input(x)
mosaic_view(rast, viewer = "base", axes = TRUE)

# create a temporary filename for the example
f <- file.path(tempdir(), "test.tif")
mosaic_export(rast, f, overwrite=TRUE)
list.files(tempdir())

}
