% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calculate_roc.R
\name{calculate_roc}
\alias{calculate_roc}
\title{Calculate the Empirical ROC curve}
\usage{
calculate_roc(M, D, ci = FALSE, alpha = 0.05)
}
\arguments{
\item{M}{continuous marker values or predictions of class labels}

\item{D}{class labels, must be coded as 0 and 1. If not numeric with 0/1,
then plotROC assumes the first level in sort order is healthy status, with
a warning.}

\item{ci}{Logical, if true, will calculate exact joint confidence regions for
the TPF and FPF}

\item{alpha}{Confidence level, ignored if \code{ci = FALSE}}
}
\value{
A dataframe containing cutoffs, estimated true and false positive
  fractions, and confidence intervals if \code{ci = TRUE}.
}
\description{
Calculate the empirical ROC curve estimate given labels and predictions
}
\details{
Confidence intervals for TPF and FPF are calculated using the exact
  method of Clopper and Pearson (1934) each at the level \code{1 - sqrt(1 -
  alpha)}. Based on result 2.4 from Pepe (2003), the cross-product of these
  intervals yields a 1 - alpha % confidence region for (FPF, TPF).
}
\examples{
D.ex <- rbinom(100, 1, .5)
calculate_roc(rnorm(100, mean = D.ex), D.ex)
calculate_roc(rnorm(100, mean = D.ex), D.ex, ci = TRUE)
}

