% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_roc.R
\name{calc_auc}
\alias{calc_auc}
\title{Calculate the Area under the ROC curve}
\usage{
calc_auc(ggroc)
}
\arguments{
\item{ggroc}{A ggplot object that contains a GeomRoc layer}
}
\description{
Given a ggplot object with a GeomRoc layer, computes the area under the ROC curve for each group
}
\examples{
D.ex <- rbinom(250, 1, .5)
rocdata <- data.frame(D = c(D.ex, D.ex),
                     M = c(rnorm(250, mean = D.ex, sd = .4), rnorm(250, mean = D.ex, sd = 1)),
                     Z = c(rep("A", 250), rep("B", 250)))

ggroc <- ggplot(rocdata, aes(m = M, d = D)) + geom_roc()
calc_auc(ggroc)
ggroc2 <- ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc()
calc_auc(ggroc2)
}

