% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{find_n_neighbors}
\alias{find_n_neighbors}
\title{Return n neighbors around given indices.}
\usage{
find_n_neighbors(el, n, max)
}
\arguments{
\item{el}{A numeric vector.}

\item{n}{Number indicating how many points around the elements of \code{el} 
need to be selected.}

\item{max}{The maximum value of the returned elements.}
}
\value{
A vector with the elements of x surrounded by n points.
}
\description{
Return n neighbors around given indices.
}
\examples{
vectorIndices <- 1:1000
indOutliers <- c(2,10, 473, 359, 717, 519)
fn3 <- find_n_neighbors(indOutliers, n=3, max=max(vectorIndices))
fn20 <- find_n_neighbors(indOutliers, n=20, max=max(vectorIndices))

# check fn3:
print(fn3)

# Plot:
emptyPlot(c(-10,1000), c(-1,1), h0=0, v0=indOutliers)
points(fn3, rep(.5, length(fn3)), pch='*')
points(fn20, rep(-.5, length(fn20)), pch='*')
}
\seealso{
Other Utility functions: \code{\link{findAbsMin}},
  \code{\link{firstLetterCap}}, \code{\link{getArrowPos}},
  \code{\link{getDec}}, \code{\link{getRange}},
  \code{\link{getRatioCoords}}, \code{\link{group_sort}},
  \code{\link{inch2coords}}, \code{\link{isColor}},
  \code{\link{list2str}}, \code{\link{move_n_point}},
  \code{\link{orderBoxplot}}, \code{\link{se}},
  \code{\link{sortGroups}}
}
\author{
Jacolien van Rij
}
