% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipsexy.R
\name{ellipsexy}
\alias{ellipsexy}
\title{Generating Coordinates of Multiple Ellipses or Circles}
\usage{
ellipsexy(x = 0, y = 0, a = 2, b = 1, start = 0,
  end = 6.283185, angle = 0, n = 40, xytype = "middle",
  fan = FALSE, group = TRUE, todf = TRUE, checks = TRUE)
}
\arguments{
\item{x}{the x coordinates of relative points. 
Its length can be larger than 1.
See \code{xytype}.}

\item{y}{the y coordinates of relative points. 
Its length can be larger than 1.
See \code{xytype}.}

\item{a}{the radius that is parallel to 
x-axis before rotation. Its length can be larger than 1.}

\item{b}{the radius that is parallel to 
y-axis before rotation. Its length can be larger than 1.}

\item{start}{default is 0. The angle of the starting 
point of the arc. Its length can be larger than 1.
Note: "radian = degree * pi / 180".}

\item{end}{default is 6.283185. The angle of the ending 
point of the arc.
Its length can be 
larger than 1.}

\item{angle}{default is 0. The rotation angle in radian.
Its length can be larger than 1.
Note: "radian = degree * pi / 180". 
The rotation direction is anti-clockwise.}

\item{n}{default is 40. The number of points used to 
draw an arc. The larger, the smoother.
It must at least be 4. However, when \code{checks} is 
FALSE, this check is ignored.
NOTE: to draw a triangle, you must use 
\code{ellipsexy(n=4, fan=FALSE)}, 
as the first and 4th points are so close. 
Similarly, to draw a rectangle, 
use \code{ellipsexy(n=5, fan=FALSE)}.}

\item{xytype}{should be one of "middle/center" (default), 
"bottomleft", "middleleft/left/centerleft". 
It indicates the type of argument 
of the middle point of an ellipse. If it is "middleleft", x and 
y are the middle-left coordinates before rotation. If it is 
"bottomleft", x and y are the coordinates of the 
bottom-left corner of the rectangle that walls the ellipse.}

\item{fan}{default is FALSE. If it is TRUE, the coordinates 
of the middle of an ellipse is added to the output 
data frame. Meanwhile, if, say, you set n = 50, then n 
becomes 49 automatically because the last position is reserved 
for the middle. This helps draw a fan.}

\item{group}{default is TRUE. It indicates 
whether to add a 3rd column named 
"g" to label the group number of each group of points. It is useful 
when using \code{aes(...group=g)} with 'ggplot2'.}

\item{todf}{default is TRUE. It indicates whether to 
combine the output (a list) into a data frame.}

\item{checks}{default is TRUE. It indicates whether 
to check input validity. Do not turn it off unless you are sure 
that the input is OK.}
}
\value{
if \code{todf = TRUE}, the output will be a data frame
with coordinates of possibly several polygons, otherwise, 
it will be a list of data frames. Data frames have 2 columns
named "x" and "y", and if \code{group = TRUE}, a third column 
named "g" is added indicating group numbers.
}
\description{
If radius a is equal to radius b, then the shape
will be a circle. 
Note: the shapes are correct  
only when \code{ggplot2::coord_fixed()} is used.
}
\examples{
library(ggplot2)
dat1=ellipsexy(x=1, y=1, 
a=seq(1, 4, length.out=8), angle=seq(0, pi, length.out=8), 
	xytype="middleleft", n=30, todf=TRUE)		
ggplot()+coord_fixed()+
	geom_polygon(show.legend=FALSE, 
		data=dat1, aes(x=x, y=y, group=g, fill=factor(g)), alpha=0.3)
}
