% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplots.R
\name{subplot}
\alias{subplot}
\title{View multiple plots in a single view}
\usage{
subplot(..., nrows = 1, which_layout = "merge", margin = 0.02)
}
\arguments{
\item{...}{any number of plotly objects}

\item{nrows}{number of rows for laying out plots in a grid-like structure.
Only used if no domain is already specified.}

\item{which_layout}{adopt the layout of which plot? If the default value of 
"merge" is used, all plot level layout options will be included in the final 
layout. This argument also accepts a numeric vector which will restric}

\item{margin}{either a single value or four values (all between 0 and 1).
If four values are provided, the first is used as the left margin, the second
is used as the right margin, the third is used as the top margin, and the
fourth is used as the bottom margin.
If a single value is provided, it will be used as all four margins.}
}
\value{
A plotly object
}
\description{
View multiple plots in a single view
}
\examples{
\dontrun{
p1 <- plot_ly(economics, x = date, y = uempmed, showlegend = F)
p2 <- plot_ly(economics, x = date, y = unemploy, showlegend = F)
offline(subplot(p1, p2, p1, p2, nrows = 2))
}
}
\author{
Carson Sievert
}

