% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{style}
\alias{style}
\title{Modify trace(s)}
\usage{
style(p, ..., traces = NULL)
}
\arguments{
\item{p}{A plotly visualization.}

\item{...}{Visual properties.}

\item{traces}{numeric vector. Which traces should be modified? By default,
attributes place in \code{...} will be applied to every trace.}
}
\description{
Modify trace(s) of an existing plotly visualization. Useful when used in
conjunction with \code{\link[=get_figure]{get_figure()}}.
}
\examples{

# style() is especially useful in conjunction with ggplotly()
# It allows you to leverage the underlying plotly.js library to change 
# the return result of ggplotly()
(p <- ggplotly(qplot(data = mtcars, wt, mpg, geom = c("point", "smooth"))))

# removes hoverinfo for the line/ribbon traces (use `plotly_json()` to verify!)
style(p, hoverinfo = "none", traces = c(2, 3))

# another example with plot_ly() instead of ggplotly()
marker <- list(
  color = "red",
  line = list(
    width = 20, 
    color = "black"
 )
)
(p <- plot_ly(x = 1:10, y = 1:10, marker = marker))

# note how the entire (marker) object is replaced if a list is provided
style(p, marker = list(line = list(color = "blue")))

# similar to plotly.js, you can update a particular attribute like so 
# https://github.com/plotly/plotly.js/issues/1866#issuecomment-314115744
style(p, marker.line.color = "blue") 
# this clobbers the previously supplied marker.line.color
style(p, marker.line = list(width = 2.5), marker.size = 10)

}
\seealso{
\code{\link[=api_download_plot]{api_download_plot()}}
}
\author{
Carson Sievert
}
