% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{Heatmap}
\alias{Heatmap}
\title{Heatmap}
\usage{
Heatmap(
  data,
  rows = NULL,
  columns_by,
  rows_name = "rows",
  columns_name = "columns",
  split_by = NULL,
  split_by_sep = "_",
  split_rows_data = FALSE,
  name = "value",
  border = TRUE,
  rows_palette = "Paired",
  rows_palcolor = NULL,
  title = NULL,
  pie_group_by = NULL,
  pie_group_by_sep = "_",
  pie_palette = "Spectral",
  pie_palcolor = NULL,
  pie_size = NULL,
  pie_name = NULL,
  pie_size_name = "size",
  pie_values = "count",
  legend_items = NULL,
  legend_discrete = FALSE,
  lower_quantile = 0,
  upper_quantile = 0.99,
  lower_cutoff = NULL,
  upper_cutoff = NULL,
  columns_by_sep = "_",
  columns_split_by = NULL,
  columns_split_name = NULL,
  columns_palette = "Paired",
  columns_palcolor = NULL,
  columns_split_by_sep = "_",
  columns_split_palette = "simspec",
  columns_split_palcolor = NULL,
  rows_data = NULL,
  rows_split_by = NULL,
  rows_split_by_sep = "_",
  rows_split_palette = "simspec",
  rows_split_palcolor = NULL,
  column_name_annotation = TRUE,
  column_name_legend = isFALSE(show_column_names) && !identical(legend.position, "none"),
  row_name_annotation = TRUE,
  row_name_legend = isFALSE(show_row_names) && !identical(legend.position, "none"),
  cluster_columns = TRUE,
  cluster_rows = TRUE,
  show_row_names = !row_name_annotation,
  show_column_names = !column_name_annotation,
  column_title = character(0),
  row_title = character(0),
  na_col = "grey85",
  row_names_side = "right",
  column_names_side = "bottom",
  bars_sample = 100,
  flip = FALSE,
  label_size = 10,
  label = identity,
  layer_fun_callback = NULL,
  cell_type = c("tile", "bars", "label", "dot", "violin", "boxplot", "pie"),
  cell_agg = mean,
  add_bg = FALSE,
  bg_alpha = 0.5,
  violin_fill = NULL,
  boxplot_fill = NULL,
  dot_size = 8,
  dot_size_name = "size",
  column_annotation = NULL,
  column_annotation_side = "top",
  column_annotation_palette = "Paired",
  column_annotation_palcolor = NULL,
  column_annotation_type = "auto",
  column_annotation_params = list(),
  column_annotation_agg = NULL,
  row_annotation = NULL,
  row_annotation_side = "left",
  row_annotation_palette = "Paired",
  row_annotation_palcolor = NULL,
  row_annotation_type = "auto",
  row_annotation_params = list(),
  row_annotation_agg = NULL,
  add_reticle = FALSE,
  reticle_color = "grey",
  palette = "RdBu",
  palcolor = NULL,
  alpha = 1,
  legend.position = "right",
  legend.direction = "vertical",
  seed = 8525,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  axes = NULL,
  axis_titles = axes,
  guides = NULL,
  design = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame used to create the heatmap.
The data should be in a long form where each row represents a instance in the heatmap.
The \code{rows} should be multiple columns if you want to plot as rows, which you can refer as "features".}

\item{rows}{A character string/vector of the column name(s) to plot for the rows
Multiple columns in the data frame can be used as the rows. It can be:
\itemize{
\item A vector of column names: The columns will be used as the rows.
\item A list of column names: The names will be used as row_split_by.
\item A formula: \code{~ col1 + col2 + ...} The columns will be excluded from the data frame and used as the rows.
\item NULL (default): The column names other than \code{columns_by}, \code{rows_split_by}, \code{columns_split_by} and \code{pie_group_by} will be used as the rows.
}}

\item{columns_by}{A character string of the column name to plot for the columns
A character/factor column is expected.
Multiple columns are also supported. If so, \code{NA}s can be used to exclude rows in that group.
If there is a single value in each group (other than \code{NA}), the group name, rather than the value,
will be shown in the column group annotation.}

\item{rows_name}{A character string specifying the name of rows, which will be shown in the
row group annotation and the legend of it.}

\item{columns_name}{A character string specifying the name of columns, which will be shown in the
column group annotation and the legend of it.
Only used when \code{columns_by} has multiple columns.}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{split_rows_data}{A logical value indicating whether to split the rows data as well using 'split_by' and 'split_by_sep'.}

\item{name}{A character string specifying the name of the main legend of the heatmap}

\item{border}{A logical value indicating whether to draw the border of the heatmap.
If TRUE, the borders of the slices will be also drawn.}

\item{rows_palette}{A character string specifying the palette of the row group annotation.
The default is "Paired".}

\item{rows_palcolor}{A character vector of colors to override the palette of the row group annotation.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{pie_group_by}{A character string of the column name to group the data for the pie chart.}

\item{pie_group_by_sep}{A character string to concatenate the columns in \code{pie_group_by} if there are multiple columns.}

\item{pie_palette}{A character string specifying the palette of the pie chart.}

\item{pie_palcolor}{A character vector of colors to override the palette of the pie chart.}

\item{pie_size}{A numeric value or a function specifying the size of the pie chart.
If it is a function, the function should take \code{count} as the argument and return the size.}

\item{pie_name}{A character string specifying the name of the legend for the pie chart.}

\item{pie_size_name}{A character string specifying the name of the legend for the pie size.}

\item{pie_values}{How to calculate the values for the pie chart. Default is "count".
Other options are "value" and a function.
\itemize{
\item "count": Count the number of instances in \code{pie_group_by}.
\item "sum": Use the values in the columns specified by \code{rows} as the values.
The sum of the values will be used.
\item A function: The function should take a vector of values as the argument and return a single value, for each
group in \code{pie_group_by}.
}}

\item{legend_items}{A numeric vector with names to specifiy the items in the main legend.
The names will be working as the labels of the legend items.}

\item{legend_discrete}{A logical value indicating whether the main legend is discrete.}

\item{lower_quantile, upper_quantile, lower_cutoff, upper_cutoff}{Vector of minimum and maximum cutoff values or quantile values for each feature.
It's applied to aggregated values when aggregated values are used (e.g. plot_type tile, label, etc).
It's applied to raw values when raw values are used (e.g. plot_type bars, etc).}

\item{columns_by_sep}{A character string to concatenate the columns in \code{columns_by} if there are multiple columns.}

\item{columns_split_by}{A character string of the column name to split the heatmap columns into slices.
A character/factor column or multiple columns are expected.}

\item{columns_split_name}{A character string specifying the name of the column split annotation.}

\item{columns_palette}{A character string specifying the palette of the column group annotation.
The default is "Paired".}

\item{columns_palcolor}{A character vector of colors to override the palette of the column group annotation.}

\item{columns_split_by_sep}{A character string to concatenate the columns in \code{columns_split_by} if there are multiple columns.}

\item{columns_split_palette}{A character string specifying the palette of the column split annotation.
The default is "simspec".}

\item{columns_split_palcolor}{A character vector of colors to override the palette of the column split annotation.}

\item{rows_data}{A character string of the column name to use as the data for the row group annotation.
If it starts with "@", it will be treated as an attribute of the data.}

\item{rows_split_by}{A character string of the column name to split the heatmap rows into slices.
A character/factor column or multiple columns are expected.}

\item{rows_split_by_sep}{A character string to concatenate the columns in \code{rows_split_by} if there are multiple columns.}

\item{rows_split_palette}{A character string specifying the palette of the row split annotation.
The default is "simspec".}

\item{rows_split_palcolor}{A character vector of colors to override the palette of the row split annotation.}

\item{column_name_annotation}{A logical value indicating whether to add the column annotation for the column names.
which is a simple annotaion indicating the column names.}

\item{column_name_legend}{A logical value indicating whether to show the legend of the column name annotation.}

\item{row_name_annotation}{A logical value indicating whether to add the row annotation for the row names.
which is a simple annotaion indicating the row names.}

\item{row_name_legend}{A logical value indicating whether to show the legend of the row name annotation.}

\item{cluster_columns}{A logical value indicating whether to cluster the columns.
If TRUE and columns_split_by is provided, the clustering will only be applied to the columns within the same split.}

\item{cluster_rows}{A logical value indicating whether to cluster the rows.
If TRUE and rows_split_by is provided, the clustering will only be applied to the rows within the same split.}

\item{show_row_names}{A logical value indicating whether to show the row names.
If TRUE, the legend of the row group annotation will be hidden.}

\item{show_column_names}{A logical value indicating whether to show the column names.
If TRUE, the legend of the column group annotation will be hidden.}

\item{column_title}{A character string/vector of the column name(s) to use as the title of the column group annotation.}

\item{row_title}{A character string/vector of the column name(s) to use as the title of the row group annotation.}

\item{na_col}{A character string specifying the color for missing values.
The default is "grey85".}

\item{row_names_side}{A character string specifying the side of the row names.
The default is "right".}

\item{column_names_side}{A character string specifying the side of the column names.
The default is "bottom".}

\item{bars_sample}{An integer specifying the number of samples to draw the bars.}

\item{flip}{A logical value indicating whether to flip the heatmap.}

\item{label_size}{A numeric value specifying the size of the labels when \code{cell_type = "label"}.}

\item{label}{A function to calculate the labels for the heatmap cells.
It takes the aggregated values as the argument and returns the labels to be shown in the heatmap.
No labels will be shown for the NA the returned values.}

\item{layer_fun_callback}{A function to add additional layers to the heatmap.
The function should have the following arguments: \code{j}, \code{i}, \code{x}, \code{y}, \code{w}, \code{h}, \code{fill}, \code{sr} and \code{sc}.
Please also refer to the \code{layer_fun} argument in \code{ComplexHeatmap::Heatmap}.}

\item{cell_type}{A character string specifying the type of the heatmap cells.
The default is values. Other options are "bars", "label", "dot", "violin", "boxplot".
Note that for pie chart, the values under columns specified by \code{rows} will not be used directly. Instead, the values
will just be counted in different \code{pie_group_by} groups. \code{NA} values will not be counted.}

\item{cell_agg}{A function to aggregate the values in the cell, for the cell type "tile" and "label".
The default is \code{mean}.}

\item{add_bg}{A logical value indicating whether to add a background to the heatmap.
Does not work with \code{cell_type = "bars"} or \code{cell_type = "tile"}.}

\item{bg_alpha}{A numeric value between 0 and 1 specifying the transparency of the background.}

\item{violin_fill}{A character vector of colors to override the fill color of the violin plot.
If NULL, the fill color will be the same as the annotion.}

\item{boxplot_fill}{A character vector of colors to override the fill color of the boxplot.
If NULL, the fill color will be the same as the annotion.}

\item{dot_size}{A numeric value specifying the size of the dot or a function to calculate the size
from the values in the cell.}

\item{dot_size_name}{A character string specifying the name of the legend for the dot size.}

\item{column_annotation}{A character string/vector of the column name(s) to use as the column annotation.
Or a list with the keys as the names of the annotation and the values as the column names.}

\item{column_annotation_side}{A character string specifying the side of the column annotation.
Could be a list with the keys as the names of the annotation and the values as the sides.}

\item{column_annotation_palette}{A character string specifying the palette of the column annotation.
The default is "Paired".
Could be a list with the keys as the names of the annotation and the values as the palettes.}

\item{column_annotation_palcolor}{A character vector of colors to override the palette of the column annotation.
Could be a list with the keys as the names of the annotation and the values as the palcolors.}

\item{column_annotation_type}{A character string specifying the type of the column annotation.
The default is "auto". Other options are "simple", "pie", "ring", "bar", "violin", "boxplot", "density".
Could be a list with the keys as the names of the annotation and the values as the types.
If the type is "auto", the type will be determined by the type and number of the column data.}

\item{column_annotation_params}{A list of parameters passed to the annotation function.
Could be a list with the keys as the names of the annotation and the values as the parameters.}

\item{column_annotation_agg}{A function to aggregate the values in the column annotation.}

\item{row_annotation}{A character string/vector of the column name(s) to use as the row annotation.
Or a list with the keys as the names of the annotation and the values as the column names.}

\item{row_annotation_side}{A character string specifying the side of the row annotation.
Could be a list with the keys as the names of the annotation and the values as the sides.}

\item{row_annotation_palette}{A character string specifying the palette of the row annotation.
The default is "Paired".
Could be a list with the keys as the names of the annotation and the values as the palettes.}

\item{row_annotation_palcolor}{A character vector of colors to override the palette of the row annotation.
Could be a list with the keys as the names of the annotation and the values as the palcolors.}

\item{row_annotation_type}{A character string specifying the type of the row annotation.
The default is "auto". Other options are "simple", "pie", "ring", "bar", "violin", "boxplot", "density".
Could be a list with the keys as the names of the annotation and the values as the types.
If the type is "auto", the type will be determined by the type and number of the row data.}

\item{row_annotation_params}{A list of parameters passed to the annotation function.
Could be a list with the keys as the names of the annotation and the values as the parameters.}

\item{row_annotation_agg}{A function to aggregate the values in the row annotation.}

\item{add_reticle}{A logical value indicating whether to add a reticle to the heatmap.}

\item{reticle_color}{A character string specifying the color of the reticle.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{seed}{The random seed to use. Default is 8525.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{axes}{A string specifying how axes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axes in individual plots.
\item 'collect' will remove duplicated axes when placed in the same run of rows or columns of the layout.
\item 'collect_x' and 'collect_y' will remove duplicated x-axes in the columns or duplicated y-axes in the rows respectively.
}}

\item{axis_titles}{A string specifying how axis titltes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axis titles in individual plots.
\item 'collect' will remove duplicated titles in one direction and merge titles in the opposite direction.
\item 'collect_x' and 'collect_y' control this for x-axis titles and y-axis titles respectively.
}}

\item{guides}{A string specifying how guides should be treated in the layout. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'collect' will collect guides below to the given nesting level, removing duplicates.
\item 'keep' will stop collection at this level and let guides be placed alongside their plot.
\item 'auto' will allow guides to be collected if a upper level tries, but place them alongside the plot if not.
}}

\item{design}{Specification of the location of areas in the layout, passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE. When specified, \code{nrow}, \code{ncol}, and \code{byrow} are ignored.
See \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}} for more details.}

\item{...}{Additional arguments.}
}
\value{
The heatmap(s).
When \code{split_by} is not provided, the function returns a single heatmap (\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap}-class object).
When \code{split_by} is provided, the function returns a combined plot of multiple heatmaps wrapped by \link[patchwork:wrap_plots]{patchwork::wrap_plots}
if \code{combine = TRUE}, otherwise, it returns a list of heatmaps.
}
\description{
Heatmap is a popular way to visualize data in matrix format. It is widely used in biology to visualize gene expression data in microarray and RNA-seq data. The heatmap is a matrix where rows represent the samples and columns represent the features. The color of each cell represents the value of the feature in the sample. The color can be continuous or discrete. The heatmap can be split by the columns or rows to show the subgroups in the data. The heatmap can also be annotated by the columns or rows to show the additional information of the samples or features.
}
\examples{
\donttest{
set.seed(8525)
data <- data.frame(
    F1 = rnorm(100, 0.1),
    F2 = rnorm(100, 0.2),
    F3 = rnorm(100),
    F4 = rnorm(100, 0.3),
    F5 = rnorm(100, -0.1),
    F6 = rnorm(100, -0.2),
    c = sample(letters[1:8], 100, replace = TRUE),
    s = sample(LETTERS[1:2], 100, replace = TRUE),
    p = sample(c("X", "Y", "Z"), 100, replace = TRUE),
    a = sample(1:5, 100, replace = TRUE),
    p1 = c(sample(c(1, NA), 100, replace = TRUE)),
    p2 = c(sample(c(1, NA), 100, replace = TRUE)),
    p3 = c(sample(c(1, NA), 100, replace = TRUE))
)
rows <- c("F1", "F2", "F3", "F4", "F5", "F6")
rows_data <- data.frame(
    rows = rep(c("F1", "F2", "F3", "F4", "F5", "F6"), each = 10),
    rows1 = rep(c("F1", "F2", "F3", "F4", "F5", "F6"), each = 10),
    rs = rep(letters[1:2], each = 30),
    rp = sample(c("X", "Y", "Z"), 60, replace = TRUE),
    rv = rnorm(60, 0.5)
)

if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data, rows = rows, columns_by = "c")
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = list(RG1 = c("F1", "F2", "F3"), RG2 = c("F4", "F5", "F6")),
        columns_by = "c"
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    # Multiple columns_by, each as a split
    Heatmap(data, rows = rows, columns_by = c("c", "s"), columns_by_sep = "/")
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data, rows = rows, columns_by = c("p1", "p2", "p3"))
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", split_by = "s",
        upper_cutoff = 2, lower_cutoff = -2, legend.position = c("none", "right"),
        design = "AAAAAA#BBBBBBB"
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data, rows = rows, columns_by = "c", columns_split_by = "s")
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", columns_split_by = "s",
        rows_data = rows_data, rows_split_by = "rs"
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", columns_split_by = "s",
        rows_data = rows_data, rows_split_by = "rs", flip = TRUE
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data, rows = rows, columns_by = "c", cell_type = "bars")
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", cell_type = "bars",
        bars_sample = 3
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", cell_type = "label",
        label = function(x) scales::number(x, accuracy = 0.01)
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", cell_type = "label",
        label = function(x) ifelse(x <= 0, NA, scales::number(x, accuracy = 0.01))
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data, rows = rows, columns_by = "c", cell_type = "dot")
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", cell_type = "dot",
        dot_size = mean
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", cell_type = "dot",
        dot_size = mean, row_name_annotation = FALSE, column_name_annotation = FALSE,
        row_names_side = "left", cluster_rows = FALSE, cluster_columns = FALSE
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", cell_type = "dot",
        dot_size = mean, add_bg = TRUE
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", cell_type = "dot",
        dot_size = mean, add_reticle = TRUE
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        cluster_rows = FALSE, cluster_columns = FALSE, columns_by = "p",
        rows = c("p1", "p2", "p3"), name = "Category", pie_group_by = "c",
        cell_type = "pie"
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        cluster_rows = FALSE, cluster_columns = FALSE, columns_by = "p",
        rows = c("p1", "p2", "p3"), name = "Category", pie_group_by = "c",
        cell_type = "pie", pie_size = sqrt, add_bg = TRUE
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data, rows = rows, columns_by = "c", cell_type = "violin")
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data, rows = rows, columns_by = "c", cell_type = "boxplot")
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", rows_data = rows_data,
        column_annotation = list(p1 = "p", p2 = "p", F1 = "F1"),
        column_annotation_type = list(p1 = "ring", p2 = "bar", F1 = "violin"),
        column_annotation_params = list(
            p1 = list(height = grid::unit(10, "mm"), show_legend = FALSE),
            F1 = list(height = grid::unit(18, "mm"))
        ),
        rows_split_by = "rs",
        row_annotation = c("rp", "rv", "rows1"),
        row_annotation_side = "right",
        row_annotation_type = list(rp = "pie", rv = "density", rows1 = "simple"),
        row_annotation_params = list(rp = list(width = grid::unit(12, "mm"))),
        show_row_names = TRUE, show_column_names = TRUE
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", rows_data = rows_data,
        column_annotation = list(p1 = "p", p2 = "p", F1 = "F1"),
        column_annotation_type = list(p1 = "ring", p2 = "bar", F1 = "violin"),
        column_annotation_params = list(
            p1 = list(height = grid::unit(10, "mm"), show_legend = FALSE),
            F1 = list(height = grid::unit(18, "mm"))
        ),
        rows_split_by = "rs",
        row_annotation = c("rp", "rv", "rows1"),
        row_annotation_side = "right",
        row_annotation_type = list(rp = "pie", rv = "density", rows1 = "simple"),
        row_annotation_params = list(rp = list(width = grid::unit(12, "mm"))),
        show_row_names = TRUE, show_column_names = TRUE, flip = TRUE
    )
}
if (requireNamespace("cluster", quietly = TRUE)) {
    Heatmap(data,
        rows = rows, columns_by = "c", split_by = "p",
        palette = list(X = "Reds", Y = "Blues", Z = "Purp")
    )
}
}
}
\seealso{
\code{\link{anno_simple}}, \code{\link{anno_points}}, \code{\link{anno_lines}}, \code{\link{anno_pie}}, \code{\link{anno_violin}}, \code{\link{anno_boxplot}}, \code{\link{anno_density}}
}
