% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_func.R
\name{plot_perm_distr}
\alias{plot_perm_distr}
\title{Plots null distributions constructed via permutation testing}
\usage{
plot_perm_distr(plsr_obj, ..., lwd = 2, bar_col = "grey",
  line_col = "red")
}
\arguments{
\item{plsr_obj}{A plsr object.}

\item{...}{Further parameters to be passed to \code{hist}.}

\item{lwd}{Line width of vertical line indicating the estimated value of the singular value.}

\item{bar_col}{Color of the bars in the histograms.}

\item{line_col}{Color of the vertial line indicating the estimated value of the singular value.}
}
\description{
Plots histograms of the null distribution for values of singular values of latent variables constructed via permutation testing.
}
\examples{
plsr_obj = pls(rating_data,tracking_data,10,10)
plot_perm_distr(plsr_obj)
\donttest{
plot_perm_distr(plsr_obj,breaks=5,lwd=5 ,bar_col = "white", line_col = "green")
}
}
