% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edata_summary.R
\name{edata_summary}
\alias{edata_summary}
\title{Creates a list of six Data Frames, one for each summarizing metric}
\usage{
edata_summary(omicsData, by = "sample", groupvar = NULL)
}
\arguments{
\item{omicsData}{object of the class 'lipidData', 'metabData', 'pepData',
'proData', or 'nmrData' created by \code{\link{as.lipidData}},
\code{\link{as.metabData}}, \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.nmrData}}, respectively.}

\item{by}{character string indicating whether summarizing metrics will be
applied by 'sample' or by 'molecule'. Defaults to 'sample'.}

\item{groupvar}{a character vector with no more than two variable names that
should be used to determine group membership of samples. The variable name
must match a column name from \code{f_data}. Defaults to NULL, in which
case group_DF attribute will be used.}
}
\value{
A list of six data frames, of class 'dataRes' (data Result), which
  are the results of applying the metrics (mean, standard deviation, median,
  percent observed, minimum and maximum) to omicsData$e_data.
}
\description{
This function takes in an omicsData object and returns a summary of the
e_data component. The six summarizing metrics include the mean, standard
deviation, median, percent observed, minimum, and maximum.
}
\details{
If groupvar is NULL and group_designation has not been applied to
  omicsData, then the metrics will be applied to each column of e_data (when
  by = 'sample) or to each row of e_data (when by = 'molecule'). When
  groupvar is provided, it must match a column name from \code{f_data}, this
  column of f_data is used to group e_data in order to apply the metrics.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

mylipid <- edata_transform(omicsData = lipid_pos_object, data_scale = "log2")
mylipid <- group_designation(omicsData = mylipid, main_effects = "Virus")
result <- edata_summary(omicsData = mylipid, by = "sample", groupvar = NULL)
\dontshow{\}) # examplesIf}
}
