% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_multiagent.R
\name{create_multiagent}
\alias{create_multiagent}
\title{Create a \strong{pointblank} \emph{multiagent} object}
\usage{
create_multiagent(..., lang = NULL, locale = NULL)
}
\arguments{
\item{...}{One or more \strong{pointblank} agent objects.}

\item{lang}{The language to use for any reporting that will be generated from
the \emph{multiagent}. (e.g., individual \emph{agent reports}, \emph{multiagent reports},
etc.). By default, \code{NULL} will create English (\code{"en"}) text. Other options
include French (\code{"fr"}), German (\code{"de"}), Italian (\code{"it"}), Spanish
(\code{"es"}), Portuguese (\code{"pt"}), Turkish (\code{"tr"}), Chinese (\code{"zh"}), Russian
(\code{"ru"}), Polish (\code{"pl"}), Danish (\code{"da"}), Swedish (\code{"sv"}), and Dutch
(\code{"nl"}).}

\item{locale}{An optional locale ID to use for formatting values in the
reporting outputs according the locale's rules. Examples include \code{"en_US"}
for English (United States) and \code{"fr_FR"} for French (France); more simply,
this can be a language identifier without a country designation, like "es"
for Spanish (Spain, same as \code{"es_ES"}).}
}
\value{
A \code{ptblank_multiagent} object.
}
\description{
Multiple \emph{agents} can be part of a single object called the \emph{multiagent}.
This can be useful when gathering multiple agents that have performed
interrogations in the past (perhaps saved to disk with \code{\link[=x_write_disk]{x_write_disk()}}).
When be part of a \emph{multiagent}, we can get a report that shows how data
quality evolved over time. This can be of interest when it's important to
monitor data quality and even the evolution of the validation plan itself.
The reporting table, generated by printing a \code{ptblank_multiagent} object or
by using the \code{\link[=get_multiagent_report]{get_multiagent_report()}} function, is, by default, organized by
the interrogation time and it automatically recognizes which validation steps
are equivalent across interrogations.
}
\section{Figures}{

\if{html}{\figure{man_create_multiagent_1.png}{options: width=100\%}}
}

\section{Function ID}{

10-1
}

\examples{
if (interactive()) {

# Let's walk through several theoretical
# data quality analyses of an extremely
# small table; that table is called
# `small_table` and we can find it as a
# dataset in this package
small_table

# To set failure limits and signal
# conditions, we designate proportional
# failure thresholds to the `warn`, `stop`,
# and `notify` states using `action_levels()`
al <- 
  action_levels(
    warn_at = 0.05,
    stop_at = 0.10,
    notify_at = 0.20
  )

# We will create four different agents
# and have slightly different validation
# steps in each of them; in the first,
# `agent_1`, eight different validation
# steps are created and the agent will
# interrogate the `small_table`
agent_1 <-
  create_agent(
    tbl = small_table,
    label = "An example.",
    actions = al
  ) \%>\%
  col_vals_gt(
    vars(date_time),
    value = vars(date),
    na_pass = TRUE
  ) \%>\%
  col_vals_gt(
    vars(b), 
    value = vars(g),
    na_pass = TRUE
  ) \%>\%
  rows_distinct() \%>\%
  col_vals_equal(
    vars(d), 
    value = vars(d),
    na_pass = TRUE
  ) \%>\%
  col_vals_between(
    vars(c), 
    left = vars(a), right = vars(d)
  ) \%>\%
  col_vals_not_between(
    vars(c),
    left = 10, right = 20,
    na_pass = TRUE
  ) \%>\%
  rows_distinct(vars(d, e, f)) \%>\%
  col_is_integer(vars(a)) \%>\%
  interrogate()

# The second agent, `agent_2`, retains
# all of the steps of `agent_1` and adds
# two more (the last of which is inactive)
agent_2 <- 
  agent_1 \%>\%
  col_exists(vars(date, date_time)) \%>\%
  col_vals_regex(
    vars(b), 
    regex = "[0-9]-[a-z]{3}-[0-9]{3}",
    active = FALSE
  ) \%>\%
  interrogate()

# The third agent, `agent_3`, adds a single
# validation step, removes the fifth one,
# and deactivates the first
agent_3 <- 
  agent_2 \%>\%
  col_vals_in_set(
    vars(f),
    set = c("low", "mid", "high")
  ) \%>\%
  remove_steps(i = 5) \%>\%
  deactivate_steps(i = 1) \%>\%
  interrogate()

# The fourth and final agent, `agent_4`,
# reactivates steps 1 and 10, and removes
# the sixth step
agent_4 <-
  agent_3 \%>\%
  activate_steps(i = 1) \%>\%
  activate_steps(i = 10) \%>\%
  remove_steps(i = 6) \%>\%
  interrogate()

# While all the agents are slightly
# different from each other, we can still
# get a combined report of them by
# creating a 'multiagent'
multiagent <-
  create_multiagent(
    agent_1, agent_2, agent_3, agent_4
  )

# Calling `multiagent` in the console
# prints the multiagent report; but we
# can get a `gt_tbl` object with the
# `get_multiagent_report()` function
report <- get_multiagent_report(multiagent)

class(report)

}

}
\seealso{
Other The multiagent: 
\code{\link{get_multiagent_report}()},
\code{\link{read_disk_multiagent}()}
}
\concept{The multiagent}
