% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{info_tabular}
\alias{info_tabular}
\title{Add information that focuses on aspects of the data table as a whole}
\usage{
info_tabular(x, ...)
}
\arguments{
\item{x}{An informant object of class \code{ptblank_informant}.}

\item{...}{Information entries as a series of named arguments. The names
refer to subsection titles within the \code{TABLE} section and the values are
the \emph{info text} (informational text that can be written as Markdown and
further styled with \emph{Text Tricks}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
When an \emph{informant} object is created with the \code{\link[=create_informant]{create_informant()}} function,
it has two starter sections: (1) 'table' and (2) 'columns'. The 'table'
section should contain a few properties upon creation, such as the supplied
table name (\code{name}) and table dimensions (as \verb{_columns} and \verb{_rows}). We can
add more table-based properties with the \code{info_tabular()} function. By
providing a series of named arguments (in the form \code{entry_name = "The *info text*."}), we can add more information that makes sense for describing the
table as a whole.
}
\section{Info Text}{

The \emph{info text} that's used for any of the \verb{info_*()} functions readily
accepts Markdown formatting, and, there are a few \emph{Text Tricks} that can be
used to spice up the presentation. Markdown links written as \verb{< link url >}
or \verb{[ link text ]( link url )} will get nicely-styled links. Any dates
expressed in the ISO-8601 standard with parentheses, \code{"(2004-12-01)"}, will
be styled with a font variation (monospaced) and underlined in purple. Spans
of text can be converted to label-style text by using: (1) double parentheses
around text for a rectangular border as in \verb{((label text))}, or (2) triple
parentheses around text for a rounded-rectangular border like \verb{(((label text)))}.

CSS style rules can be applied to spans of \emph{info text} with the following
form:

\verb{[[ info text ]]<< CSS style rules >>}

As an example of this in practice suppose you'd like to change the color of
some text to red and make the font appear somewhat thinner. A variation on
the following might be used:

\code{"This is a [[factor]]<<color: red; font-weight: 300;>> value."}

The are quite a few CSS style rules that can be used to great effect. Here
are a few you might like:
\itemize{
\item \verb{color: <a color value>;} (text color)
\item \verb{background-color: <a color value>;} (the text's background color)
\item \code{text-decoration: (overline | line-through | underline);}
\item \code{text-transform: (uppercase | lowercase | capitalize);}
\item \verb{letter-spacing: <a +/- length value>;}
\item \verb{word-spacing: <a +/- length value>;}
\item \code{font-style: (normal | italic | oblique);}
\item \code{font-weight: (normal | bold | 100-900);}
\item \code{font-variant: (normal | bold | 100-900);}
\item \verb{border: <a color value> <a length value> (solid | dashed | dotted);}
}

In the above examples, 'length value' refers to a CSS length which can be
expressed in different units of measure (e.g., \verb{12px}, \verb{1em}, etc.). Some
lengths can be expressed as positive or negative values (e.g., for
\code{letter-spacing}). Color values can be expressed in a few ways, the most
common being in the form of hexadecimal color values or as CSS color names.
}

\section{YAML}{

A \strong{pointblank} informant can be written to YAML with \code{\link[=yaml_write]{yaml_write()}} and the
resulting YAML can be used to regenerate an informant (with
\code{\link[=yaml_read_informant]{yaml_read_informant()}}) or perform the 'incorporate' action using the target
table (via \code{\link[=yaml_informant_incorporate]{yaml_informant_incorporate()}}). When \code{info_tabular()} is
represented in YAML, \emph{info text} goes into subsections of the top-level
\code{table} key. Here is an example of how a call of \code{info_tabular()} is
expressed in R code and in the corresponding YAML representation.

R statement:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant \%>\% 
  info_tabular(
    section_1 = "*info text* 1.",
    `section 2` = "*info text* 2 and \{snippet_1\}"
  )
}\if{html}{\out{</div>}}

YAML representation:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{table:
  _columns: 23
  _rows: 205.0
  _type: tbl_df
  section_1: '*info text* 1.'
  section 2: '*info text* 2 and \{snippet_1\}'
}\if{html}{\out{</div>}}

Subsection titles as defined in \code{info_tabular()} can be set in backticks if
they are not syntactically correct as an argument name without them (e.g.,
when using spaces, hyphens, etc.).

It's safest to use single quotation marks around any \emph{info text} if directly
editing it in a YAML file. Note that Markdown formatting and \emph{info snippet}
placeholders (shown here as \code{{snippet_1}}, see \code{\link[=info_snippet]{info_snippet()}} for more
information) are preserved in the YAML. The Markdown to HTML conversion is
done when printing an informant (or invoking \code{\link[=get_informant_report]{get_informant_report()}} on an
\emph{informant}) and the processing of snippets (generation and insertion) is
done when using the \code{\link[=incorporate]{incorporate()}} function. Thus, the source text is always
maintained in the YAML representation and is never written in processed form.
}

\section{Examples}{


Create a pointblank \code{informant} object with \code{\link[=create_informant]{create_informant()}}. We can
specify a \code{tbl} with the \code{~} followed by a statement that gets the
\code{small_table} dataset.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <- 
  create_informant(
    tbl = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  )
}\if{html}{\out{</div>}}

We can add \emph{info text} to describe the table with the various \verb{info_*()}
functions. In this example, we'll use \code{\link[=info_tabular]{info_tabular()}} to generally describe
the \code{small_table} dataset.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <-
  informant \%>\%
  info_tabular(
    `Row Definition` = "A row has randomized values.",
    Source = c(
      "- From the **pointblank** package.",
      "- [https://rich-iannone.github.io/pointblank/]()"
     )
   )
}\if{html}{\out{</div>}}

Upon printing the \code{informant} object, we see the additions made to the
'Table' section of the report.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_info_tabular_1.png" style="width:100\%;">
}
}
}

\section{Function ID}{

3-1
}

\seealso{
Other Information Functions: 
\code{\link{info_columns_from_tbl}()},
\code{\link{info_columns}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()},
\code{\link{snip_highest}()},
\code{\link{snip_list}()},
\code{\link{snip_lowest}()},
\code{\link{snip_stats}()}
}
\concept{Information Functions}
