% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_agent.R
\name{create_agent}
\alias{create_agent}
\title{Create a pointblank agent object}
\usage{
create_agent(validation_name = NULL)
}
\arguments{
\item{validation_name}{an optional name
for the validation pipeline that the
agent will eventually carry out during
the interrogation process. If no
value is provided, a name will be
generated based on the current system
time.}
}
\value{
an agent object.
}
\description{
Creates an agent object.
}
\examples{
# Create a simple data frame
# with a column of numerical values
df <-
  data.frame(
    a = c(5, 7, 6, 5, 8, 7))

# Create a pointblank `agent` object
agent <- create_agent()

# Then, as with any `ptblank_agent`
# object, we can focus on a table,
# add validation steps, and then
# eventually use `interrogate()`
# to perform the validations;
# here, in a single validation
# step, we expect that values in
# column `a` are always greater
# than 4
agent <-
  agent \%>\%
  focus_on(tbl_name = "df") \%>\%
  col_vals_gt(
    column = a,
    value = 4) \%>\%
  interrogate()
 
# A summary can be produced using
# `get_interrogation_summary()`; we
# we will just obtain the first
# 7 columns of its output
(agent \%>\%
  get_interrogation_summary())[, 1:7]
#> # A tibble: 1 x 7
#>   tbl_name  db_type assertion_type column value regex all_passed
#>      <chr>    <chr>          <chr>  <chr> <dbl> <chr>      <lgl>
#> 1       df local_df    col_vals_gt      a     4  <NA>       TRUE
}
