% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_po}
\alias{read_po}
\title{Read PO and POT files}
\usage{
read_po(po_file)
}
\arguments{
\item{po_file}{A string giving a path to a PO file.}
}
\value{
An object of class \code{\link{po}}. The \code{source_type} and
\code{file_type} elements are automatically determined from the file
name.
}
\description{
Reads .PO and .POT translation files.
}
\examples{
# read_po is used for both po and pot files
pot_file <- system.file("extdata/R-summerof69.pot", package = "poio")
(pot <- read_po(pot_file))
}
\seealso{
\code{\link[tools]{xgettext}}
}
