% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe__frame.R
\name{DataFrame_sort}
\alias{DataFrame_sort}
\title{DataFrame Sort}
\usage{
DataFrame_sort(by, ..., descending = FALSE, nulls_last = FALSE)
}
\arguments{
\item{by}{Column(s) to sort by. Column name strings, character vector of
column names, or Iterable \verb{Into<Expr>} (e.g. one Expr, or list mixed Expr and
column name strings).}

\item{...}{more columns to sort by as above but provided one Expr per argument.}

\item{descending}{Sort descending? Default = FALSE logical vector of length 1 or same length
as number of Expr's from above by + ....}

\item{nulls_last}{Bool default FALSE, place all nulls_last?}
}
\value{
DataFrame
}
\description{
sort a DataFrame by on or more Expr.
}
\details{
by and ... args allow to either provide e.g. a list of Expr or something which can
be converted into an Expr e.g. \verb{$sort(list(e1,e2,e3))},
or provide each Expr as an individual argument \verb{$sort(e1,e2,e3)}´ ... or both.
}
\examples{
df = mtcars
df$mpg[1] = NA
df = pl$DataFrame(df)
df$sort("mpg")
df$sort("mpg", nulls_last = TRUE)
df$sort("cyl", "mpg")
df$sort(c("cyl", "mpg"))
df$sort(c("cyl", "mpg"), descending = TRUE)
df$sort(c("cyl", "mpg"), descending = c(TRUE, FALSE))
df$sort(pl$col("cyl"), pl$col("mpg"))
}
\keyword{DataFrame}
