% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_deps.R
\name{get_package_deps}
\alias{get_package_deps}
\title{Create a list of R Package Dependencies}
\usage{
get_package_deps(app_dir = ".", verbose = TRUE)
}
\arguments{
\item{app_dir}{path to a directory containing R scripts or RMarkdown files. Defaults to current working directory if left blank.}

\item{verbose}{logical - defaults to TRUE. Will provide feedback to detected or invalid R packages.}
}
\value{
a list of package dependencies
}
\description{
Given a \code{path} to a directory this function will scan all \code{.R} and
\code{.Rmd} files for any used R Packages along with their CRAN versions or GitHub references.
}
\details{
Currently, detections are made via \code{\link[automagic:parse_packages]{automagic::parse_packages()}} which supports
the following calls within the code: \code{library()}, \code{require()}, and
prefixed \code{::} calls to functions.

Once an initial vector of package detections is built, it is further processed by
validating that each detection is indeed a valid \code{CRAN} or public \code{GitHub} package
and can be installed.
}
\examples{
library(polished)
dir <- system.file("examples", "polished_example_01", package = "polished")
pkg_deps <- polished:::get_package_deps(dir)

}
\seealso{
\code{\link[automagic:parse_packages]{automagic::parse_packages()}}
}
\keyword{internal}
