% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secure_server.R
\name{secure_server}
\alias{secure_server}
\title{Secure your Shiny app's server}
\usage{
secure_server(
  server,
  custom_sign_in_server = NULL,
  custom_admin_server = NULL,
  allow_reconnect = FALSE
)
}
\arguments{
\item{server}{A Shiny server function (e.g \code{function(input, output, session) {}})}

\item{custom_sign_in_server}{Either \code{NULL}, the default, or a Shiny module server containing your custom
sign in server logic.}

\item{custom_admin_server}{Either \code{NULL}, the default, or a Shiny module server function containing your custom admin
server functionality.}

\item{allow_reconnect}{argument to pass to the Shiny \code{session$allowReconnect()} function. Defaults to
\code{FALSE}.  Set to \code{TRUE} to allow reconnect with shiny-server and Rstudio Connect.  Set to \code{"force"}
for local testing.  See \url{https://shiny.rstudio.com/articles/reconnecting.html} for more information.}
}
\description{
This function is used to secure your Shiny app's server function.  Make sure to pass
your Shiny app's server function as the first argument to \code{secure_server()} at
the bottom of your Shiny app's \code{server.R} file.
}
