% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{get_action_set}
\alias{get_action_set}
\title{Get Action Set}
\usage{
get_action_set(object)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}
}
\value{
Character vector.
}
\description{
\code{get_action_set} returns the action set, i.e., the possible
actions at each stage for the policy data object.
}
\examples{
### Two stages:
source(system.file("sim", "two_stage.R", package="polle"))
d2 <- sim_two_stage(5e2, seed=1)
# constructing policy_data object:
pd2 <- policy_data(d2,
                  action = c("A_1", "A_2"),
                  baseline = c("B"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd2

# getting the actions set:
get_action_set(pd2)
}
