% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_single_stage_multi_actions}
\alias{sim_single_stage_multi_actions}
\title{Simulate Single-Stage Multi-Action Data}
\usage{
sim_single_stage_multi_actions(n = 1000, seed = NULL)
}
\arguments{
\item{n}{Number of observations.}

\item{seed}{Integer.}
}
\value{
data.frame with n rows and columns z, x, a, and u.
}
\description{
Simulate Single-Stage Multi-Action Data
}
\details{
\code{sim_single_stage_multi_actions} samples \code{n} iid observation
\eqn{O = (z, x, a, u)} with the following distribution:
\deqn{
z, x \sim Uniform([0,1])\\
\tilde a \sim \mathcal{N}(0,1)\\
a \mid \tilde a \sim
\begin{cases}
0 \quad if \quad \tilde a < -1\\
1 \quad if \quad \tilde a -1 \leq a < 0.5\\
2 \quad otherwise
\end{cases}\\
u \mid z, x \sim \mathcal{N}(x + z + I\{a=2\}(x-0.5) + I\{a=1\}(x^2 + z -0.5), 1)
}
}
