% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_method.R
\docType{methods}
\name{compare,partition-method}
\alias{compare}
\alias{compare,cooccurrences-method}
\alias{compare,ngrams-method}
\alias{compare,partition-method}
\alias{compare,partitionBundle-method}
\title{compare features}
\usage{
\S4method{compare}{partition}(x, y, included = FALSE, method = "chisquare",
  verbose = FALSE)

\S4method{compare}{partitionBundle}(x, y, included = FALSE,
  method = "chisquare", verbose = TRUE, mc = getOption("polmineR.mc"),
  progress = FALSE)

\S4method{compare}{cooccurrences}(x, y, included = FALSE, method = "ll",
  mc = TRUE, verbose = TRUE)

\S4method{compare}{ngrams}(x, y, included = FALSE, method = "chisquare",
  verbose = TRUE, ...)
}
\arguments{
\item{x}{a partition or partitionBundle object}

\item{y}{a partition object, it is assumed that the coi is a subcorpus of
ref}

\item{included}{TRUE if coi is part of ref, defaults to FALSE}

\item{method}{the statistical test to apply (chisquare or log likelihood)}

\item{verbose}{logical, defaults to TRUE}

\item{mc}{logical, whether to use multicore}

\item{progress}{logical}

\item{...}{further parameters}
}
\value{
The function returns a data frame with the following structure:
- absolute frequencies in the first row
- ...
}
\description{
The features of two objects, usually a partition defining a corpus of 
interest, and a partition defining a reference corpus are compared. 
The most important purpose is term extraction.
}
\examples{
\dontrun{
  use(polmineR.sampleCorpus)
  kauder <- partition("PLPRBTTXT", text_name="Volker Kauder", pAttribute="word")
  all <- partition("PLPRBTTXT", text_date=".*", regex=TRUE, pAttribute="word")
  terms_kauder <- compare(kauder, all, included=TRUE)
  top100 <- subset(terms_kauder, rank_chisquare <= 100)
}
\dontrun{
  use(polmineR.sampleCorpus)
  byName <- partitionBundle("PLPRBTTXT", sAttribute="text_name")
  byName <- enrich(byName, pAttribute="word")
  all <- partition("PLPRBTTXT", text_date=".*", regex=TRUE, pAttribute="word")
  result <- compare(byName, all, included=TRUE, progress=TRUE)
  dtm <- as.DocumentTermMatrix(result, col="chisquare")
}
}
\author{
Andreas Blaette
}
\references{
Manning / Schuetze ...
}

