% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat_class.R, R/view_method.R
\docType{class}
\name{textstat-class}
\alias{textstat-class}
\alias{as.data.frame,textstat-method}
\alias{show,textstat-method}
\alias{dim,textstat-method}
\alias{colnames,textstat-method}
\alias{rownames,textstat-method}
\alias{names,textstat-method}
\alias{as.DataTables,textstat-method}
\alias{head,textstat-method}
\alias{tail,textstat-method}
\alias{dim,textstat-method}
\alias{nrow,textstat-method}
\alias{round,textstat-method}
\alias{colnames,textstat-method}
\alias{sort,textstat-method}
\alias{as.bundle}
\alias{+,textstat,textstat-method}
\alias{subset,textstat-method}
\alias{as.data.table,textstat-method}
\alias{as.data.frame,textstat-method}
\alias{[[,textstat-method}
\alias{[,textstat,ANY,ANY,ANY-method}
\alias{view,textstat-method}
\title{S4 textstat class}
\usage{
\S4method{head}{textstat}(x, ...)

\S4method{tail}{textstat}(x, ...)

\S4method{dim}{textstat}(x)

\S4method{nrow}{textstat}(x)

\S4method{round}{textstat}(x, digits = 2)

\S4method{colnames}{textstat}(x)

\S4method{sort}{textstat}(x, by, decreasing = TRUE)

as.bundle(object, ...)

\S4method{+}{textstat,textstat}(e1, e2)

\S4method{subset}{textstat}(x, ...)

\S4method{as.data.table}{textstat}(x)

\S4method{as.data.frame}{textstat}(x)

\S4method{[[}{textstat}(x, i)

\S4method{[}{textstat,ANY,ANY,ANY}(x, i, j)

\S4method{view}{textstat}(.Object)
}
\arguments{
\item{x}{textstat object}

\item{...}{further parameters}

\item{digits}{no of digits}

\item{by}{by}

\item{decreasing}{logical}

\item{object}{an object}

\item{e1}{object 1}

\item{e2}{object 2}

\item{i}{vector to index data.table in stat-slot}

\item{j}{vector to index data.table in stat-slot}

\item{.Object}{an object}
}
\description{
Superclass for features, context, and partition class.
}
\details{
Objects derived from the \code{textstat} class can be indexed with simple
square brackets ("[") to get rows specified by an numeric/integer vector,
and with double square brackets ("[[") to get specific columns from the 
\code{data.table} in the slot \code{stat}.
}
\section{Slots}{

\describe{
\item{\code{pAttribute}}{Object of class \code{"character"} p-attribute of the query}

\item{\code{corpus}}{Object of class \code{"character"}}

\item{\code{stat}}{Object of class \code{"data.table"} statistics of the analysis}

\item{\code{name}}{name of the object}

\item{\code{encoding}}{Object of class \code{"character"} encoding of the corpus}
}}

\examples{
use("polmineR")
P <- partition("GERMAPARLMINI", date = ".*", pAttribute = "word", regex = TRUE)
y <- cooccurrences(P, query = "Arbeit")
y[1:25]
y[,c("word", "ll")]
y[1:25, "word"]
y[1:25][["word"]]
y[which(y[["word"]] \%in\% c("Arbeit", "Sozial"))]
y[ y[["word"]] \%in\% c("Arbeit", "Sozial") ]
}
