% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{parental_quantities}
\alias{parental_quantities}
\title{Calculate frequency of each markertype.}
\usage{
parental_quantities(
  dosage_matrix,
  parent1 = "P1",
  parent2 = "P2",
  log = NULL,
  ...
)
}
\arguments{
\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{parent1}{Character string specifying the first (usually maternal) parentname.}

\item{parent2}{Character string specifying the second (usually paternal) parentname.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}

\item{\dots}{Arguments passed to \code{\link{barplot}}}
}
\value{
A named vector containing the frequency of each markertype in the dataset.
}
\description{
Plots and returns frequency information for each markertype.
}
\examples{
data("ALL_dosages","screened_data")
parental_quantities(dosage_matrix=ALL_dosages)
parental_quantities(dosage_matrix=screened_data)
}
