% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{visualiseGIC}
\alias{visualiseGIC}
\title{Visualise Genotypic Information Coefficient}
\usage{
visualiseGIC(
  GIC_list,
  add_rug = TRUE,
  add_leg = FALSE,
  ylimits = NULL,
  gic.cex = 1,
  show_markers = TRUE,
  add.mainTitle = TRUE,
  plot.cols = NULL
)
}
\arguments{
\item{GIC_list}{List of GIC data, the output of \code{\link{estimate_GIC}}}

\item{add_rug}{Should original marker positions be added to the plot?}

\item{add_leg}{Should a legend be added to the plot?}

\item{ylimits}{Optional argument to control the plotting area, by default \code{NULL}}

\item{gic.cex}{Option to increase the size of the GIC}

\item{show_markers}{Should markers be shown?}

\item{add.mainTitle}{Should a main title be added to the plot?}

\item{plot.cols}{Optional argument to specify plot colours, otherwise suitable contrasting colours are chosen}
}
\value{
The phased map data for the specified region, recoded into 1's and 0's.
}
\description{
Function to visualise the GIC of a certain region
}
\examples{
data("GIC_4x")
visualiseGIC(GIC_list = GIC_4x)
}
