% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI-object.R
\name{DBI-object}
\alias{DBI-object}
\alias{dbDataType,Pool-method}
\alias{dbGetInfo,Pool-method}
\alias{dbIsValid,Pool-method}
\title{DBIObject methods.}
\usage{
\S4method{dbDataType}{Pool}(dbObj, obj, ...)

\S4method{dbGetInfo}{Pool}(dbObj, ...)

\S4method{dbIsValid}{Pool}(dbObj, obj, ...)
}
\arguments{
\item{dbObj, obj, ...}{See \code{\link[DBI:dbDataType]{DBI::dbDataType()}}.}
}
\description{
Pool object wrappers around DBIObject methods. See
\code{\link[DBI:dbDataType]{DBI::dbDataType()}}, \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}}
and \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}} for the original
documentation.
}
\examples{
if (requireNamespace("RSQLite", quietly = TRUE)) {
  pool <- dbPool(RSQLite::SQLite(), dbname = ":memory:")

  dbGetInfo(pool)
  dbIsValid(pool)

  dbDataType(pool, 1:5)
  dbDataType(pool, 1)
  dbDataType(pool, TRUE)
  dbDataType(pool, Sys.Date())
  dbDataType(pool, Sys.time())
  dbDataType(pool, Sys.time() - as.POSIXct(Sys.Date()))
  dbDataType(pool, c("x", "abc"))
  dbDataType(pool, list(raw(10), raw(20)))
  dbDataType(pool, I(3))
  dbDataType(pool, iris)

  poolClose(pool)

  dbIsValid(pool)

} else {
  message("Please install the 'RSQLite' package to run this example")
}
}
