% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{getmode}
\alias{getmode}
\title{Calculate the mode of a distribution}
\usage{
getmode(x, xlim, weights = NULL, alpha = 0.7, precision = 1000)
}
\arguments{
\item{x}{is a numeric vector containing the values of the distribution.}

\item{xlim}{is a vector with two entries.The first entry is the minimum of
the \code{x} distribution and the second entry is the maximum value of the
\code{x} distribution. Ideally these values should be the minimum and
maximum value of the prior for this particular parameter.}

\item{weights}{this is an optional input consisting of a vector with the
prior weights for the locfit function.}

\item{alpha}{numeric value with the alpha parameter of the locfit function.
The default value is 0.7}

\item{precision}{value indicating the number of entries evaluated. The larger
the value the higher the precision. The default value is 1000.}
}
\value{
a numeric value of the mode of the input distribution.
}
\description{
Computes and outputs the mode of the input distribution.
}
\details{
The \code{\link[locfit:locfit]{locfit::locfit()}} function is used to fit a local regression to the
distribution. The \code{\link[stats:predict]{stats::predict()}} function is then used to predict the
y-axis values of the locfit and the mode is defined as the value where that
prediction is maximized. Note that if this function is not able to fit a
local regression to the distribution, then the mode of the distribution will
be assumed to be equal to the median.
}
\examples{
# create a random distribution
x <- rnorm(n = 100, mean = 2, sd = 25)

# compute the mode of the distribution
getmode(x = x, xlim = c(min(x), max(x)))

}
