% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{forcePool}
\alias{forcePool}
\title{Randomly select the required number of loci from the pooled sequencing data}
\usage{
forcePool(nSims, pool, target)
}
\arguments{
\item{nSims}{is an integer representing how many types of simulations were
performed. The possible types of simulations include loci without barriers
against migration between divergent ecotypes, loci without migration from
the C towards the W ecotype, loci without migration from the W towards the
C ecotypes and loci where no migration occurs between divergent ecotypes.}

\item{pool}{a list containing the "minor" element, representing the number of
reads with the minor-allele and the "total" element that contains
information about the total number of Reads. The list should also contain a
"major" entry with the information about reads containing the major-allele.}

\item{target}{is a vector with the required number of loci per category. If
extra loci were simulated, this vector informs how many loci of each
simulation type should be randomly selected.}
}
\value{
a list with three names entries

\item{major}{a list with one entry per locus. Each entry is a matrix with
the number of major allele reads for each population. Each column
represents a different site and each row a different population.}

\item{minor}{a list with one entry per locus. Each entry is a matrix with
the number of minor allele reads for each population. Each column
represents a different site and each row a different population.}

\item{total}{a list with one entry per locus. Each entry is a matrix with
the coverage of each population. Each column represents a different site
and each row a different population.}
}
\description{
This function removes loci without polymorphic sites and then randomly
selects the required number of loci from a larger dataset.
}
\details{
If extra loci were simulated to try to have sufficient loci to keep the
required number of loci after filtering, then this function is used to remove
extra loci. This is done by randomly selecting the required number of loci
from the full contingent of extra simulated loci.
}
\keyword{internal}
