% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.fstats.R
\name{compute.fstats}
\alias{compute.fstats}
\title{Estimate the F-statistics (F2, F3, F3star, F4, Dstat)}
\usage{
compute.fstats(
  x,
  nsnp.per.bjack.block = 0,
  computeDstat = FALSE,
  return.F4.blockjackknife.samples = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A pooldata object containing Pool-Seq information or a countdata object containing allele count information}

\item{nsnp.per.bjack.block}{Number of consecutive SNPs within a block for block-jackknife (default=0, i.e., no block-jackknife sampling)}

\item{computeDstat}{If TRUE compute Dstatistics (i.e. scaled F4). This may add some non negligible computation time if the number of population is large (n>15)}

\item{return.F4.blockjackknife.samples}{If TRUE (and nsnp.per.bjack.block>0) return F4 estimates for each block-jackknife sample (useful to compute F4 ratios standard errors)}

\item{verbose}{If TRUE extra information is printed on the terminal}
}
\value{
An object of class fstats (see help(fstats) for details)
}
\description{
Estimate the F-statistics (F2, F3, F3star, F4, Dstat)
}
\details{
The function estimates for the n populations (or pools) represented in the input object x:
\enumerate{
\item The F2 statistics for all the \eqn{n(n-1)/2} pairs of populations (or pools) and their scaled version (equivalent to Fst as compute with \code{\link{compute.pairwiseFST}} with method="Identity")
\item If n>2, The F3 statistics for all the \eqn{npools(npools-1)(npools-2)/2} possible triplets of populations (or pools) and their scaled version (named F3star after Patterson et al., 2012)
\item If n>3, The F4 statistics and the D-statistics (a scaled version of the F4) for all the \eqn{npools(npools-1)(npools-2)*(npools-3)/8} possible quadruplets of populations
\item The estimated within population heterozygosities (=1-Q1)
}
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 res.fstats=compute.fstats(pooldata)
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}},\code{\link{genobaypass2pooldata}} or \code{\link{genoselestim2pooldata}}. To generate coundata object, see \code{\link{genobaypass2countdata}} or \code{\link{genotreemix2countdata}}.
}
