% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoch.R
\name{stoch}
\alias{stoch}
\title{Project population dynamics}
\usage{
stoch(A, what = "all", Aseq = "unif", vector = NULL, Astart = NULL,
  iterations = 10000, discard = 1000, PREcheck = FALSE)
}
\arguments{
\item{A}{a list of matrices. \code{stoch} uses \code{\link{project}} to 
perform a stochastic' projection where the matrix varies with each timestep. 
The sequence of matrices is determined using \code{Aseq}. Matrices must be 
square, non-negative and numeric, and all matrices must have the same dimension.}

\item{what}{what should be returned. A character vector with possible entries
"lambda" (to calcualate stochastic growth), "var" (to calculate variance in 
stochastic growth) and/or "all" (to calculate both).}

\item{Aseq}{the sequence of matrices in a stochastic projection. 
\code{Aseq} may be either:
\itemize{
 \item "unif" (default), which results in every matrix in \code{A} having an 
 equal, random chance of being chosen at each timestep.
 \item a square, nonnegative left-stochastic matrix describing a 
 first-order markov chain used to choose the matrices. This should have the 
 same dimension as the number of matrices in \code{A}. 
 \item a numeric vector giving a specific sequence which corresponds to the
 matrices in \code{A}.
 \item a character vector giving a specific sequence which corresponds to the
 names of the matrices in \code{A}.
}}

\item{vector}{(optional) a numeric vector describing the age/stage 
distribution used to calculate the projection. If \code{vector} is not 
specified, a random vector is generated. Long-term stochastic dynamics should 
usually be the same for any vector, although if all the matrices in A are 
reducible (see \code{\link{isIrreducible}}), that may not be the case.}

\item{Astart}{(optional) in a stochastic projection, the matrix with which to
initialise the projection (either numeric, corresponding to the matrices in 
\code{A}, or character, corresponding to the names of matrices in \code{A}). 
When \code{Astart = NULL}, a random initial matrix is chosen.}

\item{iterations}{the number of projection intervals. The default is 1e+5.}

\item{discard}{the number of initial projection intervals to discard, to 
discount near-term effects arising from the choice of vector. The default is
1e+3}

\item{PREcheck}{many functions in \code{popdemo} first check Primitivity, 
Reducibility and/or Ergodicity of matrices, with associated warnings and/or 
errors if a matrix breaks any assumptions. Set \code{PREcheck=FALSE} if you
want to bypass these checks.}
}
\value{
A numeric vector with two possible elements: "lambda" (the stochastic population
growth rate) and "var" (the variance in stochastic population growth rate). Values
returned depend on what's passed to \code{what}.
}
\description{
Analyse long-term dynamics of a stochastic population matrix projection model.
}
\details{
Calculates stochastic growth and its variance for a given stochastic population 
matrix projection model.
}
\examples{
  # load the Polar bear data
  ( data(Pbear) )

  # Find the stochastic growth for a time series with uniform probability of each
  # matrix
  ( lambda_unif <- stoch(Pbear, what = "lambda", Aseq = "unif") )

  # Find the variance in stochastic growth for a time series with uniform 
  # probability of each matrix
  ( var_unif <- stoch(Pbear, what = "var", Aseq = "unif") )
                 
  # Find stochastic growth and its variance for a time series with a sequence of
  # matrices where "bad" years happen with probability q
  q <- 0.5
  prob_seq <- c(rep(1-q,3)/3, rep(q,2)/2)
  Pbear_seq <- matrix(rep(prob_seq,5), 5, 5)
  ( var_unif <- stoch(Pbear, what = "var", Aseq = Pbear_seq) )
  
}
\concept{
stochastic growth variance projection project population
}
